/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.application;

import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.io.reader.NamedReader;
import com.yahoo.path.Path;
import com.yahoo.text.XML;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Xml {
    private static final Logger log = Logger.getLogger(Xml.class.getPackage().toString());
    private static final DocumentBuilderFactory factory = Xml.createDocumentBuilderFactory();

    public static Document getDocument(Reader reader) {
        try {
            return Xml.getDocumentBuilder().parse(new InputSource(reader));
        }
        catch (IOException | SAXException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setXIncludeAware(false);
        try {
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            return factory;
        }
        catch (ParserConfigurationException e) {
            log.log(Level.SEVERE, "Could not initialize XML parser", e);
            throw new RuntimeException(e);
        }
    }

    private static synchronized DocumentBuilder getDocumentBuilder() {
        try {
            return factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            log.log(Level.WARNING, "No XML parser available - " + String.valueOf(e));
            return null;
        }
    }

    static DocumentBuilder getPreprocessDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = Xml.createDocumentBuilderFactory();
        factory.setValidating(false);
        return factory.newDocumentBuilder();
    }

    static Document copyDocument(Document input) throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        DOMSource source = new DOMSource(input);
        DOMResult result = new DOMResult();
        transformer.transform(source, result);
        return (Document)result.getNode();
    }

    static String documentAsString(Document document, boolean prettyPrint) throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        if (prettyPrint) {
            transformer.setOutputProperty("indent", "yes");
        } else {
            transformer.setOutputProperty("indent", "no");
        }
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(document), new StreamResult(writer));
        String[] lines = writer.toString().split("\n");
        StringBuilder b = new StringBuilder();
        for (String line : lines) {
            if (line.isBlank()) continue;
            b.append(line).append("\n");
        }
        return b.toString();
    }

    static String documentAsString(Document document) throws TransformerException {
        return Xml.documentAsString(document, false);
    }

    public static Element getElement(Reader reader) {
        return XML.getDocument((Reader)reader).getDocumentElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Element> allElemsFromPath(ApplicationPackage app, String pathFromAppRoot) {
        ArrayList<Element> ret = new ArrayList<Element>();
        List files = null;
        try {
            files = app.getFiles(Path.fromString((String)pathFromAppRoot), ".xml", true);
            for (NamedReader reader : files) {
                ret.add(Xml.getElement((Reader)reader));
            }
        }
        catch (Throwable throwable) {
            NamedReader.closeAll(files);
            throw throwable;
        }
        NamedReader.closeAll((List)files);
        return ret;
    }

    public static List<Element> mergeElems(Element parent, String name, ApplicationPackage app, String pathFromAppRoot) {
        List children = XML.getChildren((Element)parent, (String)name);
        List<Element> allFromFiles = Xml.allElemsFromPath(app, pathFromAppRoot);
        for (Element fromFile : allFromFiles) {
            children.addAll(XML.getChildren((Element)fromFile, (String)name));
        }
        return children;
    }
}

