/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.application.provider;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.io.IOUtils;
import com.yahoo.path.Path;
import com.yahoo.text.Utf8;
import com.yahoo.vespa.config.util.ConfigUtils;
import com.yahoo.yolean.Exceptions;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FilesApplicationFile
extends ApplicationFile {
    private static final Logger log = Logger.getLogger("FilesApplicationFile");
    private final File file;
    private final ObjectMapper mapper = new ObjectMapper();

    public FilesApplicationFile(Path path, File file) {
        super(path);
        this.file = file;
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public boolean exists() {
        return this.file.exists();
    }

    public ApplicationFile delete() {
        if (this.file.isDirectory()) {
            if (!this.listFiles().isEmpty()) {
                throw new RuntimeException("Can't delete, directory not empty: " + String.valueOf((Object)this) + "(" + String.valueOf(this.listFiles()) + ")." + this.listFiles().size());
            }
            File[] files = this.file.listFiles();
            if (files != null) {
                for (File f : files) {
                    FilesApplicationFile.deleteFile(f);
                }
            }
        }
        if (!this.file.delete()) {
            throw new IllegalStateException("Unable to delete: " + String.valueOf((Object)this));
        }
        Exceptions.uncheck(() -> this.writeMetaFile("", "deleted"));
        return this;
    }

    public static boolean deleteFile(File path) {
        if (path.isDirectory()) {
            File[] files;
            for (File value : files = path.listFiles()) {
                if (value.isDirectory()) {
                    FilesApplicationFile.deleteFile(value);
                    continue;
                }
                value.delete();
            }
        }
        return path.delete();
    }

    public Reader createReader() throws FileNotFoundException {
        return new FileReader(this.file);
    }

    public InputStream createInputStream() throws FileNotFoundException {
        return new FileInputStream(this.file);
    }

    public ApplicationFile createDirectory() {
        if (this.file.isDirectory()) {
            return this;
        }
        if (this.file.exists()) {
            throw new IllegalArgumentException("Unable to create directory, file exists: " + String.valueOf(this.file));
        }
        if (!this.file.mkdirs()) {
            throw new IllegalArgumentException("Unable to create directory: " + String.valueOf(this.file));
        }
        try {
            this.writeMetaFile("", "new");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public ApplicationFile writeFile(Reader input) {
        return (ApplicationFile)Exceptions.uncheck(() -> this.writeFile(Utf8.toBytes((String)IOUtils.readAll((Reader)input))));
    }

    public ApplicationFile writeFile(InputStream input) {
        return (ApplicationFile)Exceptions.uncheck(() -> this.writeFile(input.readAllBytes()));
    }

    private ApplicationFile writeFile(byte[] data) {
        if (this.file.getParentFile() != null) {
            this.file.getParentFile().mkdirs();
        }
        String status = this.file.exists() ? "changed" : "new";
        Exceptions.uncheck(() -> Files.write(this.file.toPath(), data, new OpenOption[0]));
        Exceptions.uncheck(() -> this.writeMetaFile(data, status));
        return this;
    }

    public ApplicationFile appendFile(String value) {
        if (this.file.getParentFile() != null) {
            this.file.getParentFile().mkdirs();
        }
        try {
            String status = this.file.exists() ? "changed" : "new";
            IOUtils.writeFile((File)this.file, (String)value, (boolean)true);
            this.writeMetaFile(value, status);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public List<ApplicationFile> listFiles(ApplicationFile.PathFilter filter) {
        ArrayList<ApplicationFile> files = new ArrayList<ApplicationFile>();
        if (!this.file.isDirectory()) {
            return files;
        }
        FileFilter fileFilter = pathname -> filter.accept(this.path.append(pathname.getName()));
        File[] list = this.file.listFiles(fileFilter);
        if (list == null) {
            return files;
        }
        for (File child : list) {
            if (child.getName().startsWith(".")) continue;
            files.add(new FilesApplicationFile(this.path.append(child.getName()), child));
        }
        return files;
    }

    private void writeMetaFile(String data, String status) throws IOException {
        this.writeMetaFile(Utf8.toBytes((String)data), status);
    }

    private void writeMetaFile(byte[] data, String status) throws IOException {
        File metaDir = this.createMetaDir();
        log.log(Level.FINE, () -> "meta dir=" + String.valueOf(metaDir));
        File metaFile = new File(String.valueOf(metaDir) + "/" + this.getPath().getName());
        if (status == null) {
            status = metaFile.exists() ? "changed" : "new";
        }
        String hash = this.file.isDirectory() || status.equals("deleted") ? "" : ConfigUtils.getMd5((byte[])data);
        this.mapper.writeValue(metaFile, (Object)new ApplicationFile.MetaData(status, hash));
    }

    private File createMetaDir() {
        File metaDir = this.getMetaDir();
        if (!metaDir.exists()) {
            log.log(Level.FINE, () -> "Creating meta dir " + String.valueOf(metaDir));
            metaDir.mkdirs();
        }
        return metaDir;
    }

    private File getMetaDir() {
        String substring = this.file.getAbsolutePath().substring(0, this.file.getAbsolutePath().lastIndexOf("/") + 1);
        return new File(substring + String.valueOf(Path.fromString((String)".meta/")));
    }

    public ApplicationFile.MetaData getMetaData() {
        File metaDir = this.getMetaDir();
        File metaFile = new File(String.valueOf(metaDir) + "/" + this.getPath().getName());
        log.log(Level.FINE, () -> "Getting metadata for " + String.valueOf(metaFile));
        if (metaFile.exists()) {
            try {
                return (ApplicationFile.MetaData)this.mapper.readValue(metaFile, ApplicationFile.MetaData.class);
            }
            catch (IOException e) {
                System.out.println("whot:" + Exceptions.toMessageString((Throwable)e));
            }
        }
        try {
            if (this.file.isDirectory()) {
                return new ApplicationFile.MetaData("new", "");
            }
            return new ApplicationFile.MetaData("new", ConfigUtils.getMd5((byte[])IOUtils.readFileBytes((File)this.file)));
        }
        catch (IOException | IllegalArgumentException e) {
            return null;
        }
    }

    public long getSize() {
        return this.file.length();
    }

    public int compareTo(ApplicationFile other) {
        if (other == this) {
            return 0;
        }
        return this.getPath().getName().compareTo(other.getPath().getName());
    }
}

