/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.application;

import com.yahoo.config.model.application.provider.Bundle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class ConfigDefinitionDir {
    private final File defDir;

    public ConfigDefinitionDir(File defDir) {
        this.defDir = defDir;
    }

    public void addConfigDefinitionsFromBundle(Bundle bundle, List<Bundle> bundlesAdded) {
        try {
            this.checkAndCopyUserDefs(bundle, bundlesAdded);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to add config definitions from bundle " + bundle.getFile().getAbsolutePath(), e);
        }
    }

    private void checkAndCopyUserDefs(Bundle bundle, List<Bundle> bundlesAdded) throws IOException {
        for (Bundle.DefEntry def : bundle.getDefEntries()) {
            this.checkUserDefConflict(bundle, def, bundlesAdded);
            String defFilename = def.defNamespace + "." + def.defName + ".def";
            FileOutputStream out = new FileOutputStream(new File(this.defDir, defFilename));
            ((OutputStream)out).write(def.contents.getBytes());
            ((OutputStream)out).close();
        }
    }

    private void checkUserDefConflict(Bundle bundle, Bundle.DefEntry userDef, List<Bundle> bundlesAdded) {
        String defName = userDef.defName;
        String defNamespace = userDef.defNamespace;
        File[] builtinDefsWithSameName = this.defDir.listFiles((dir, name) -> name.matches(defName + ".def") || name.matches(defNamespace + "." + defName + ".def"));
        if (builtinDefsWithSameName != null && builtinDefsWithSameName.length > 0) {
            String message = "a built-in config definition (" + this.getFilePathsCommaSeparated(builtinDefsWithSameName) + ")";
            for (Bundle b : bundlesAdded) {
                for (Bundle.DefEntry defEntry : b.getDefEntries()) {
                    if (!defEntry.defName.equals(defName) || !defEntry.defNamespace.equals(defNamespace)) continue;
                    message = "the same config definition in the bundle '" + b.getFile().getName() + "'";
                }
            }
            throw new IllegalArgumentException("The config definition with name '" + defNamespace + "." + defName + "' contained in the bundle '" + bundle.getFile().getName() + "' conflicts with " + message + ". Please choose a different name.");
        }
    }

    private String getFilePathsCommaSeparated(File[] files) {
        StringBuilder sb = new StringBuilder();
        if (files.length > 0) {
            sb.append(files[0].getAbsolutePath());
            for (int i = 1; i < files.length; ++i) {
                sb.append(", ");
                sb.append(files[i].getAbsolutePath());
            }
        }
        return sb.toString();
    }
}

