/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.application;

import com.yahoo.config.application.PreProcessor;
import com.yahoo.config.application.Xml;
import com.yahoo.text.XML;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class PropertiesProcessor
implements PreProcessor {
    private static final Logger log = Logger.getLogger(PropertiesProcessor.class.getName());
    private final LinkedHashMap<String, String> properties = new LinkedHashMap();

    PropertiesProcessor() {
    }

    @Override
    public Document process(Document input) throws TransformerException {
        Document doc = Xml.copyDocument(input);
        Document document = this.buildProperties(doc);
        this.applyProperties(document.getDocumentElement());
        return document;
    }

    private Document buildProperties(Document input) {
        NodeList list = input.getElementsByTagNameNS("properties", "properties");
        while (list.getLength() > 0) {
            Element propertiesElement = (Element)list.item(0);
            Element parent = (Element)propertiesElement.getParentNode();
            for (Node node : XML.getChildren((Element)propertiesElement)) {
                String propertyName = node.getNodeName();
                if (this.properties.containsKey(propertyName)) {
                    log.log(Level.WARNING, "Duplicate definition for property '" + propertyName + "' detected");
                }
                this.properties.put(propertyName, node.getTextContent());
            }
            parent.removeChild(propertiesElement);
            list = input.getElementsByTagNameNS("properties", "properties");
        }
        return input;
    }

    private void applyProperties(Element parent) {
        NamedNodeMap attributes = parent.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node a = attributes.item(i);
            if (!PropertiesProcessor.hasProperty(a)) continue;
            this.replaceAttributePropertyWithValue(a);
        }
        if (XML.getChildren((Element)parent).isEmpty() && parent.getTextContent() != null && PropertiesProcessor.hasPropertyInElement(parent)) {
            this.replaceElementPropertyWithValue(parent);
        }
        for (Element child : XML.getChildren((Element)parent)) {
            this.applyProperties(child);
        }
    }

    private void replaceAttributePropertyWithValue(Node a) {
        String propertyValue = a.getNodeValue();
        String replacedPropertyValue = this.replaceValue(propertyValue);
        a.setNodeValue(replacedPropertyValue);
    }

    private String replaceValue(String propertyValue) {
        ArrayList<String> keys = new ArrayList<String>(this.properties.keySet());
        Collections.sort(keys, Collections.reverseOrder(Comparator.comparing(String::length)));
        for (String key : keys) {
            String value = this.properties.get(key);
            if (propertyValue.equals("${" + key + "}")) {
                String regex = "\\$\\{" + key + "\\}";
                return propertyValue.replaceAll(regex, value);
            }
            if (!propertyValue.contains(key)) continue;
            return propertyValue.replaceAll("\\$\\{" + key + "\\}", value);
        }
        throw new IllegalArgumentException("Unable to find property replace in " + propertyValue);
    }

    private void replaceElementPropertyWithValue(Node a) {
        String propertyValue = a.getTextContent();
        String replacedPropertyValue = this.replaceValue(propertyValue);
        a.setTextContent(replacedPropertyValue);
    }

    private static boolean hasProperty(Node node) {
        return PropertiesProcessor.hasProperty(node.getNodeValue());
    }

    private static boolean hasPropertyInElement(Node node) {
        return PropertiesProcessor.hasProperty(node.getTextContent());
    }

    private static boolean hasProperty(String s) {
        return s.matches("^.*\\$\\{.+\\}.*$");
    }

    public LinkedHashMap<String, String> getProperties() {
        return this.properties;
    }
}

