/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.application;

import com.yahoo.yolean.function.ThrowingFunction;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Predicate;

public class FileSystemWrapper {
    Predicate<Path> existence;
    ThrowingFunction<Path, byte[], IOException> reader;

    private FileSystemWrapper(Predicate<Path> existence, ThrowingFunction<Path, byte[], IOException> reader) {
        this.existence = existence;
        this.reader = reader;
    }

    public static FileSystemWrapper ofFiles(Predicate<Path> existence, ThrowingFunction<Path, byte[], IOException> reader) {
        return new FileSystemWrapper(existence, reader);
    }

    public static FileSystemWrapper getDefault() {
        return FileSystemWrapper.ofFiles(x$0 -> Files.exists(x$0, new LinkOption[0]), (ThrowingFunction<Path, byte[], IOException>)((ThrowingFunction)Files::readAllBytes));
    }

    public FileWrapper wrap(Path path) {
        return new FileWrapper(path);
    }

    public class FileWrapper {
        private final Path path;

        private FileWrapper(Path path) {
            this.path = path;
        }

        public Path path() {
            return this.path;
        }

        public boolean exists() {
            return FileSystemWrapper.this.existence.test(this.path);
        }

        public byte[] content() throws IOException {
            return (byte[])FileSystemWrapper.this.reader.apply((Object)this.path);
        }

        public Optional<FileWrapper> parent() {
            return Optional.ofNullable(this.path.getParent()).map(path -> FileSystemWrapper.this.wrap((Path)path));
        }

        public FileWrapper child(String name) {
            return FileSystemWrapper.this.wrap(this.path.resolve(name));
        }
    }
}

