/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.application;

import com.google.common.collect.ImmutableSet;
import com.yahoo.config.application.PreProcessor;
import com.yahoo.config.application.Xml;
import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.RegionName;
import com.yahoo.log.LogLevel;
import com.yahoo.text.XML;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

class OverrideProcessor
implements PreProcessor {
    private static final Logger log = Logger.getLogger(OverrideProcessor.class.getName());
    private final Environment environment;
    private final RegionName region;
    private static final String ATTR_ID = "id";
    private static final String ATTR_ENV = "environment";
    private static final String ATTR_REG = "region";

    public OverrideProcessor(Environment environment, RegionName region) {
        this.environment = environment;
        this.region = region;
    }

    @Override
    public Document process(Document input) throws TransformerException {
        log.log((Level)LogLevel.DEBUG, "Preprocessing overrides with " + this.environment + "." + this.region);
        Document ret = Xml.copyDocument(input);
        Element root = ret.getDocumentElement();
        this.applyOverrides(root, Context.empty());
        return ret;
    }

    private void applyOverrides(Element parent, Context context) {
        context = this.getParentContext(parent, context);
        Map<String, List<Element>> elementsByTagName = this.elementsByTagNameAndId(XML.getChildren((Element)parent));
        this.retainOverriddenElements(elementsByTagName);
        for (Map.Entry<String, List<Element>> entry : elementsByTagName.entrySet()) {
            this.pruneOverrides(parent, entry.getValue(), context);
        }
        for (Element child : XML.getChildren((Element)parent)) {
            this.applyOverrides(child, context);
            child.removeAttributeNS("vespa", ATTR_ENV);
            child.removeAttributeNS("vespa", ATTR_REG);
        }
    }

    private Context getParentContext(Element parent, Context context) {
        Object environments = context.environments;
        Object regions = context.regions;
        if (environments.isEmpty()) {
            environments = this.getEnvironments(parent);
        }
        if (regions.isEmpty()) {
            regions = this.getRegions(parent);
        }
        return Context.create(environments, regions);
    }

    private void pruneOverrides(Element parent, List<Element> children, Context context) {
        this.checkConsistentInheritance(children, context);
        this.pruneNonMatchingEnvironmentsAndRegions(parent, children);
        this.retainMostSpecificEnvironmentAndRegion(parent, children, context);
    }

    private void checkConsistentInheritance(List<Element> children, Context context) {
        for (Element child : children) {
            Set<Environment> environments = this.getEnvironments(child);
            Set<RegionName> regions = this.getRegions(child);
            if (!(environments.isEmpty() || context.environments.isEmpty() || context.environments.containsAll(environments))) {
                throw new IllegalArgumentException("Environments in child (" + environments + ") are not a subset of those of the parent (" + context.environments + ") at " + child);
            }
            if (regions.isEmpty() || context.regions.isEmpty() || context.regions.containsAll(regions)) continue;
            throw new IllegalArgumentException("Regions in child (" + regions + ") are not a subset of those of the parent (" + context.regions + ") at " + child);
        }
    }

    private void pruneNonMatchingEnvironmentsAndRegions(Element parent, List<Element> children) {
        Iterator<Element> elemIt = children.iterator();
        while (elemIt.hasNext()) {
            Element child = elemIt.next();
            if (this.matches(this.getEnvironments(child), this.getRegions(child))) continue;
            parent.removeChild(child);
            elemIt.remove();
        }
    }

    private boolean matches(Set<Environment> elementEnvironments, Set<RegionName> elementRegions) {
        if (!elementEnvironments.isEmpty() && !elementEnvironments.contains(this.environment)) {
            return false;
        }
        if (!elementRegions.isEmpty()) {
            if (this.environment.equals((Object)Environment.prod) && !elementRegions.contains(this.region)) {
                return false;
            }
            if (!this.environment.equals((Object)Environment.prod) && elementEnvironments.isEmpty()) {
                return false;
            }
        }
        return true;
    }

    private void retainMostSpecificEnvironmentAndRegion(Element parent, List<Element> children, Context context) {
        ArrayList<Element> bestMatches = new ArrayList<Element>();
        int bestMatch = 0;
        for (Element child : children) {
            bestMatch = this.updateBestMatches(bestMatches, child, bestMatch, context);
        }
        if (bestMatch > 0) {
            this.doElementSpecificProcessingOnOverride(bestMatches);
            for (Element child : children) {
                if (bestMatches.contains(child)) continue;
                parent.removeChild(child);
            }
        }
    }

    private int updateBestMatches(List<Element> bestMatches, Element child, int bestMatch, Context context) {
        int overrideCount = this.getNumberOfOverrides(child, context);
        if (overrideCount >= bestMatch) {
            if (overrideCount > bestMatch) {
                bestMatches.clear();
            }
            bestMatches.add(child);
            return overrideCount;
        }
        return bestMatch;
    }

    private int getNumberOfOverrides(Element child, Context context) {
        Object elementRegions;
        int currentMatch = 0;
        Set<Environment> elementEnvironments = this.hasEnvironment(child) ? this.getEnvironments(child) : context.environments;
        Object object = elementRegions = this.hasRegion(child) ? this.getRegions(child) : context.regions;
        if (!elementEnvironments.isEmpty() && elementEnvironments.contains(this.environment)) {
            ++currentMatch;
        }
        if (!elementRegions.isEmpty() && elementRegions.contains(this.region)) {
            ++currentMatch;
        }
        return currentMatch;
    }

    private void doElementSpecificProcessingOnOverride(List<Element> elements) {
        elements.forEach(element -> {
            if (element.getTagName().equals("nodes") && element.getChildNodes().getLength() == 0) {
                element.setAttribute("required", "true");
            }
        });
    }

    private void retainOverriddenElements(Map<String, List<Element>> elementsByTagName) {
        Iterator<Map.Entry<String, List<Element>>> it = elementsByTagName.entrySet().iterator();
        while (it.hasNext()) {
            List<Element> elements = it.next().getValue();
            boolean hasOverrides = false;
            for (Element element : elements) {
                if (!this.hasEnvironment(element) && !this.hasRegion(element)) continue;
                hasOverrides = true;
            }
            if (hasOverrides) continue;
            it.remove();
        }
    }

    private boolean hasRegion(Element element) {
        return element.hasAttributeNS("vespa", ATTR_REG);
    }

    private boolean hasEnvironment(Element element) {
        return element.hasAttributeNS("vespa", ATTR_ENV);
    }

    private Set<Environment> getEnvironments(Element element) {
        String env = element.getAttributeNS("vespa", ATTR_ENV);
        if (env == null || env.isEmpty()) {
            return Collections.emptySet();
        }
        return Arrays.stream(env.split(" ")).map(Environment::from).collect(Collectors.toSet());
    }

    private Set<RegionName> getRegions(Element element) {
        String reg = element.getAttributeNS("vespa", ATTR_REG);
        if (reg == null || reg.isEmpty()) {
            return Collections.emptySet();
        }
        return Arrays.stream(reg.split(" ")).map(RegionName::from).collect(Collectors.toSet());
    }

    private Map<String, List<Element>> elementsByTagNameAndId(List<Element> children) {
        LinkedHashMap<String, List<Element>> elementsByTagName = new LinkedHashMap<String, List<Element>>();
        for (Element child : children) {
            String key = child.getTagName();
            if (child.hasAttribute(ATTR_ID)) {
                key = key + child.getAttribute(ATTR_ID);
            }
            if (!elementsByTagName.containsKey(key)) {
                elementsByTagName.put(key, new ArrayList());
            }
            ((List)elementsByTagName.get(key)).add(child);
        }
        return elementsByTagName;
    }

    private static String getPrintableElement(Element element) {
        StringBuilder sb = new StringBuilder(element.getTagName());
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            sb.append(" ").append(attributes.item(i).getNodeName());
        }
        return sb.toString();
    }

    private static String getPrintableElementRecursive(Element element) {
        StringBuilder sb = new StringBuilder();
        sb.append(element.getTagName());
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            sb.append(" ").append(attributes.item(i).getNodeName()).append("=").append(attributes.item(i).getNodeValue());
        }
        List children = XML.getChildren((Element)element);
        if (children.size() > 0) {
            sb.append("\n");
            for (Element e : children) {
                sb.append("\t").append(OverrideProcessor.getPrintableElementRecursive(e));
            }
        }
        return sb.toString();
    }

    private static final class Context {
        final ImmutableSet<Environment> environments;
        final ImmutableSet<RegionName> regions;

        private Context(Set<Environment> environments, Set<RegionName> regions) {
            this.environments = ImmutableSet.copyOf(environments);
            this.regions = ImmutableSet.copyOf(regions);
        }

        static Context empty() {
            return new Context((Set<Environment>)ImmutableSet.of(), (Set<RegionName>)ImmutableSet.of());
        }

        public static Context create(Set<Environment> environments, Set<RegionName> regions) {
            return new Context(environments, regions);
        }
    }
}

