/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.application.provider;

import com.yahoo.collections.Tuple2;
import com.yahoo.vespa.config.util.ConfigUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;

public class Bundle {
    private static final Logger log = Logger.getLogger(Bundle.class.getName());
    private static final String DEFPATH = "configdefinitions/";
    private final File bundleFile;
    private final JarFile jarFile;
    private final List<DefEntry> defEntries;

    public Bundle(JarFile jarFile, File bundleFile) {
        this.jarFile = jarFile;
        this.bundleFile = bundleFile;
        this.defEntries = this.findDefEntries();
    }

    public static List<Bundle> getBundles(File bundleDir) {
        try {
            ArrayList<Bundle> bundles = new ArrayList<Bundle>();
            for (File bundleFile : Bundle.getBundleFiles(bundleDir)) {
                JarFile jarFile;
                try {
                    jarFile = new JarFile(bundleFile);
                }
                catch (ZipException e) {
                    throw new IllegalArgumentException("Error opening jar file '" + bundleFile.getName() + "'. Please check that this is a valid jar file");
                }
                bundles.add(new Bundle(jarFile, bundleFile));
            }
            return bundles;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static List<File> getBundleFiles(File bundleDir) {
        if (!bundleDir.isDirectory()) {
            return new ArrayList<File>();
        }
        return Arrays.asList(bundleDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        }));
    }

    public List<DefEntry> getDefEntries() {
        return Collections.unmodifiableList(this.defEntries);
    }

    private List<DefEntry> findDefEntries() {
        ArrayList<DefEntry> defEntries = new ArrayList<DefEntry>();
        ZipEntry defDir = this.jarFile.getEntry(DEFPATH);
        if (defDir == null || !defDir.isDirectory()) {
            return defEntries;
        }
        Enumeration<JarEntry> entries = this.jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.endsWith(".def")) continue;
            if (name.matches("^configdefinitions/.*\\.def$")) {
                defEntries.add(new DefEntry(this, entry));
                continue;
            }
            log.info("Config definition file '" + name + "' in component '" + this.jarFile.getName() + "' will not be used. Files must reside in the '" + DEFPATH + "' directory in the .jar file");
        }
        return defEntries;
    }

    public JarFile getJarFile() {
        return this.jarFile;
    }

    public File getFile() {
        return this.bundleFile;
    }

    public static class DefEntry {
        private final Bundle bundle;
        private final ZipEntry zipEntry;
        public final String defName;
        public final String defNamespace;
        public final String contents;

        public DefEntry(Bundle bundle, ZipEntry zipEntry) {
            this.bundle = bundle;
            this.zipEntry = zipEntry;
            String entryName = zipEntry.getName();
            Tuple2 nameAndNamespace = ConfigUtils.getNameAndNamespaceFromString((String)entryName.substring(Bundle.DEFPATH.length(), entryName.indexOf(".def")));
            this.defName = (String)nameAndNamespace.first;
            this.defNamespace = this.getNamespace();
            if (this.defNamespace.isEmpty()) {
                throw new IllegalArgumentException("Config definition '" + this.defName + "' is missing a package (or namespace)");
            }
            this.contents = this.getContents();
        }

        private String getNamespace() {
            return ConfigUtils.getDefNamespace((Reader)this.getReader());
        }

        private String getContents() {
            StringBuilder ret = new StringBuilder("");
            BufferedReader reader = new BufferedReader(this.getReader());
            try {
                String str = reader.readLine();
                while (str != null) {
                    ret.append(str);
                    str = reader.readLine();
                    if (str == null) continue;
                    ret.append("\n");
                }
                reader.close();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed reading contents of def-file '" + this.defName + ".def in component " + this.bundle.jarFile.getName(), e);
            }
            return ret.toString();
        }

        public Reader getReader() {
            if (this.zipEntry == null) {
                return new StringReader("");
            }
            try {
                return new InputStreamReader(this.bundle.jarFile.getInputStream(this.zipEntry), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("IOException", e);
            }
        }
    }
}

