/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.application.provider;

import com.yahoo.config.model.api.ConfigDefinitionRepo;
import com.yahoo.io.IOUtils;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.config.ConfigDefinitionKey;
import com.yahoo.vespa.config.buildergen.ConfigDefinition;
import com.yahoo.vespa.config.util.ConfigUtils;
import com.yahoo.vespa.defaults.Defaults;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class StaticConfigDefinitionRepo
implements ConfigDefinitionRepo {
    private static final Logger log = Logger.getLogger(StaticConfigDefinitionRepo.class.getName());
    private final Map<ConfigDefinitionKey, ConfigDefinition> configDefinitions = new LinkedHashMap<ConfigDefinitionKey, ConfigDefinition>();
    private static final String DEFAULT_SERVER_DEF_DIR = Defaults.getDefaults().underVespaHome("var/db/vespa/config_server/serverdb/classes");

    public StaticConfigDefinitionRepo() {
        this(new File(DEFAULT_SERVER_DEF_DIR));
    }

    public StaticConfigDefinitionRepo(File definitionDir) {
        this.initialize(definitionDir);
    }

    private void initialize(File definitionDir) {
        if (!definitionDir.exists()) {
            return;
        }
        for (File def : definitionDir.listFiles((dir, name) -> name.matches(".*\\.def"))) {
            this.addConfigDefinition(def);
        }
    }

    private void addConfigDefinition(File def) {
        try {
            ConfigDefinitionKey key = ConfigUtils.createConfigDefinitionKeyFromDefFile((File)def);
            if (key.getNamespace().isEmpty()) {
                key = new ConfigDefinitionKey(key.getName(), "config");
            }
            this.addConfigDefinition(key, def);
        }
        catch (IOException e) {
            log.log(LogLevel.WARNING, "Exception adding config definition " + def, e);
        }
    }

    private void addConfigDefinition(ConfigDefinitionKey key, File defFile) throws IOException {
        String payload = IOUtils.readFile((File)defFile);
        this.configDefinitions.put(key, new ConfigDefinition(key.getName(), StringUtils.split((String)payload, (String)"\n")));
    }

    public Map<ConfigDefinitionKey, ConfigDefinition> getConfigDefinitions() {
        return Collections.unmodifiableMap(this.configDefinitions);
    }
}

