/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.component;

import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.Spec;
import com.yahoo.component.SpecSplitter;
import com.yahoo.component.Version;
import java.util.concurrent.atomic.AtomicInteger;

public final class ComponentId
implements Comparable<ComponentId> {
    private final Spec<Version> spec;
    private final boolean anonymous;
    private static final AtomicInteger threadIdCounter = new AtomicInteger(0);
    private static final ThreadLocal<Counter> threadLocalUniqueId = ThreadLocal.withInitial(Counter::new);
    private static final ThreadLocal<String> threadId = ThreadLocal.withInitial(() -> "_" + threadIdCounter.getAndIncrement() + "_");
    private final String stringValue;

    public ComponentId(String id) {
        this(new SpecSplitter(id));
    }

    private ComponentId(SpecSplitter splitter) {
        this(splitter.name, Version.fromString(splitter.version), splitter.namespace);
    }

    public ComponentId(String name, Version version, ComponentId namespace) {
        this(name, version, namespace, false);
    }

    public ComponentId(String name, Version version) {
        this(name, version, null);
    }

    private ComponentId(String id, Version version, ComponentId namespace, boolean anonymous) {
        this.spec = new Spec<Version>(new VersionHandler(), id, version, namespace);
        this.anonymous = anonymous;
        this.stringValue = this.spec.createStringValue();
    }

    public ComponentId nestInNamespace(ComponentId namespace) {
        if (namespace == null) {
            return this;
        }
        ComponentId newNamespace = this.getNamespace() == null ? namespace : this.getNamespace().nestInNamespace(namespace);
        return new ComponentId(this.getName(), this.getVersion(), newNamespace);
    }

    public String getName() {
        return this.spec.name;
    }

    public Version getVersion() {
        return (Version)this.spec.version;
    }

    public ComponentId getNamespace() {
        return this.spec.namespace;
    }

    public String stringValue() {
        return this.stringValue;
    }

    public String toString() {
        return this.spec.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComponentId)) {
            return false;
        }
        ComponentId c = (ComponentId)o;
        if (this.isAnonymous() || c.isAnonymous()) {
            return false;
        }
        return c.stringValue().equals(this.stringValue);
    }

    public int hashCode() {
        return this.stringValue.hashCode();
    }

    public ComponentSpecification toSpecification() {
        if (this.isAnonymous()) {
            throw new RuntimeException("Can't generate a specification for an anonymous component id.");
        }
        return new ComponentSpecification(this.getName(), this.getVersion().toSpecification(), this.getNamespace());
    }

    @Override
    public int compareTo(ComponentId other) {
        if (this.isAnonymous() ^ other.isAnonymous()) {
            return this.isAnonymous() ? -1 : 1;
        }
        return this.spec.compareTo(other.spec);
    }

    public static ComponentId createAnonymousComponentId(String baseName) {
        return new ComponentId(ComponentId.createAnonymousId(baseName), null, null, true);
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public ComponentId withoutNamespace() {
        return new ComponentId(this.getName(), this.getVersion(), null);
    }

    public static ComponentId fromString(String componentId) {
        try {
            return componentId != null ? new ComponentId(componentId) : null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Illegal component id: '" + componentId + "'", e);
        }
    }

    public String toFileName() {
        return this.stringValue.replace(":", "-").replace("/", ".");
    }

    public static ComponentId fromFileName(String fileName) {
        int dash;
        String id = fileName;
        Version version = null;
        ComponentId namespace = null;
        int at = id.indexOf("@");
        if (at > 0) {
            String newId = id.substring(0, at);
            namespace = ComponentId.fromString(id.substring(at + 1));
            id = newId;
        }
        if ((dash = id.lastIndexOf("-")) > 0) {
            String newId = id.substring(0, dash);
            try {
                version = new Version(id.substring(dash + 1));
                id = newId;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        id = id.replace(".", "/");
        return new ComponentId(id, version, namespace);
    }

    public static void resetGlobalCountersForTests() {
        threadId.set("_0_");
        threadLocalUniqueId.set(new Counter());
    }

    private static String createAnonymousId(String name) {
        return name + threadId.get() + threadLocalUniqueId.get().getAndIncrement();
    }

    public static ComponentId newAnonymous(String spec) {
        SpecSplitter splitter = new SpecSplitter(spec);
        return new ComponentId(splitter.name, Version.fromString(splitter.version), splitter.namespace, true);
    }

    private static final class VersionHandler
    implements Spec.VersionHandler<Version> {
        private VersionHandler() {
        }

        @Override
        public Version emptyVersion() {
            return Version.emptyVersion;
        }

        @Override
        public int compare(Version v1, Version v2) {
            return v1.compareTo(v2);
        }
    }

    private static final class Counter {
        private int count = 0;

        private Counter() {
        }

        public int getAndIncrement() {
            return this.count++;
        }
    }
}

