/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.component;

import com.yahoo.component.Version;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;

public class VersionCompatibility {
    private final Node root;

    private VersionCompatibility(Node root) {
        this.root = root;
    }

    public static VersionCompatibility fromVersionList(List<String> versions) {
        Node root = new Node();
        for (String spec : versions) {
            String[] parts = spec.split("\\.");
            if (parts.length < 1 || parts.length > 3) {
                throw new IllegalArgumentException("Each spec must have 1 to 3 parts, but found '" + spec + "'");
            }
            boolean wildcard = false;
            Node node = root;
            for (int i = 0; i < 3; ++i) {
                String part;
                String string = i < parts.length ? parts[i] : (part = wildcard ? null : "0");
                if (wildcard && part != null && !part.equals("*")) {
                    throw new IllegalArgumentException("Wildcard parts may only have wildcard children, but found '" + spec + "'");
                }
                if ("*".equals(part)) {
                    wildcard = true;
                    if (node.children.isEmpty()) {
                        node = node.children.computeIfAbsent(-1, __ -> new Node());
                        continue;
                    }
                    throw new IllegalArgumentException("Wildcards may not have siblings, but got: " + versions);
                }
                if (part == null) continue;
                int number = Integer.parseInt(part);
                if (number < 0) {
                    throw new IllegalArgumentException("Version parts must be non-negative, but found '" + spec + "'");
                }
                if (node.children.containsKey(-1)) {
                    throw new IllegalArgumentException("Wildcards may not have siblings, but got: " + versions);
                }
                if (i < 2) {
                    node = node.children.computeIfAbsent(number, __ -> new Node());
                    continue;
                }
                if (node.children.put(number, new Node()) == null) continue;
                throw new IllegalArgumentException("Duplicate element '" + spec + "'");
            }
        }
        return new VersionCompatibility(root);
    }

    public boolean accept(Version first, Version second) {
        return !this.refuse(first, second);
    }

    public boolean refuse(Version first, Version second) {
        if (first.compareTo(second) > 0) {
            return this.refuse(second, first);
        }
        if (first.compareTo(second) == 0) {
            return false;
        }
        return this.refuse(new int[]{first.getMajor(), first.getMinor(), first.getMicro()}, new int[]{second.getMajor(), second.getMinor(), second.getMicro()}, 0, this.root, this.root);
    }

    private boolean refuse(int[] first, int[] second, int i, Node left, Node right) {
        if (left == null && right == null) {
            return false;
        }
        if (i == 3) {
            return right != null;
        }
        int u = first[i];
        int v = second[i];
        if (left == right) {
            Node wildcard = (Node)left.children.get(-1);
            if (wildcard != null) {
                return u != v || this.refuse(first, second, i + 1, wildcard, wildcard);
            }
            if (!left.children.tailMap(u, false).headMap(v, false).isEmpty()) {
                return true;
            }
            return this.refuse(first, second, i + 1, (Node)left.children.get(u), (Node)left.children.get(v));
        }
        if (left != null && (left.children.containsKey(-1) || !left.children.tailMap(u, false).isEmpty())) {
            return true;
        }
        if (right != null && (right.children.containsKey(-1) || !right.children.headMap(v, false).isEmpty())) {
            return true;
        }
        return this.refuse(first, second, i + 1, left == null ? null : (Node)left.children.get(u), right == null ? null : (Node)right.children.get(v));
    }

    private static class Node {
        final NavigableMap<Integer, Node> children = new TreeMap<Integer, Node>();

        private Node() {
        }
    }
}

