/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.component;

import com.yahoo.component.ComponentId;
import com.yahoo.container.util.Util;

final class Spec<VERSION> {
    private final VersionHandler<VERSION> versionHandler;
    final String name;
    final VERSION version;
    final ComponentId namespace;

    Spec(VersionHandler<VERSION> versionHandler, String name, VERSION version, ComponentId namespace) {
        assert (name != null);
        this.validateName(name);
        this.versionHandler = versionHandler;
        this.name = name;
        this.version = Util.firstNonNull(version, versionHandler.emptyVersion());
        this.namespace = namespace;
    }

    String createStringValue() {
        if (this.isNonEmpty(this.version) || this.namespace != null) {
            StringBuilder builder = new StringBuilder(this.name);
            if (this.isNonEmpty(this.version)) {
                builder.append(':').append(this.version);
            }
            if (this.namespace != null) {
                builder.append('@').append(this.namespace.stringValue());
            }
            return builder.toString();
        }
        return this.name;
    }

    private void validateName(String name) {
        if (name == null || name.isEmpty() || name.contains("@") || name.contains(":")) {
            throw new IllegalArgumentException("The name '" + name + "' is expected to be non-empty and not contain {:, @}");
        }
    }

    public String toString() {
        if (this.isNonEmpty(this.version) || this.namespace != null) {
            StringBuilder builder = new StringBuilder(this.name);
            if (this.isNonEmpty(this.version)) {
                builder.append(':').append(this.version);
            }
            if (this.namespace != null) {
                builder.append(" in ").append(this.namespace.toString());
            }
            return builder.toString();
        }
        return this.name;
    }

    private boolean isNonEmpty(VERSION version) {
        return !version.equals(this.versionHandler.emptyVersion());
    }

    public int compareTo(Spec<VERSION> other) {
        int result = this.name.compareTo(other.name);
        if (result != 0) {
            return result;
        }
        result = this.versionHandler.compare(this.version, other.version);
        if (result != 0) {
            return result;
        }
        return this.compare(this.namespace, other.namespace);
    }

    private int compare(ComponentId n1, ComponentId n2) {
        if (n1 == null && n2 == null) {
            return 0;
        }
        if (n1 == null) {
            return -1;
        }
        if (n2 == null) {
            return 1;
        }
        return n1.compareTo(n2);
    }

    static interface VersionHandler<VERSION> {
        public VERSION emptyVersion();

        public int compare(VERSION var1, VERSION var2);
    }
}

