/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.utils.communication.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.yahoo.vespa.clustercontroller.utils.communication.http.HttpResult;

public final class JsonHttpResult
extends HttpResult {
    private static final ObjectMapper mapper = new ObjectMapper();
    private JsonNode json;
    private boolean failedParsing = false;

    public JsonHttpResult() {
        this.addHeader("Content-Type", "application/json");
    }

    public JsonHttpResult(HttpResult other) {
        super(other);
        if (other.getContent() == null) {
            this.setParsedJson((JsonNode)new ObjectNode(mapper.getNodeFactory()));
            return;
        }
        try {
            Object object = other.getContent();
            if (object instanceof JsonNode) {
                JsonNode jsonContent = (JsonNode)object;
                this.setParsedJson(jsonContent);
            } else {
                this.setParsedJson(mapper.readTree(other.getContent().toString()));
            }
        }
        catch (JsonProcessingException e) {
            this.failedParsing = true;
            this.setParsedJson(this.createErrorJson(e.getMessage(), other));
        }
    }

    private JsonNode createErrorJson(String error, HttpResult other) {
        ObjectNode root = new ObjectNode(mapper.getNodeFactory());
        root.put("error", "Invalid JSON in output: " + error);
        root.put("output", other.getContent().toString());
        return root;
    }

    public JsonHttpResult setJson(JsonNode o) {
        this.setContent(o);
        this.json = o;
        return this;
    }

    private void setParsedJson(JsonNode o) {
        this.json = o;
    }

    public JsonNode getJson() {
        return this.json;
    }

    @Override
    public void printContent(StringBuilder sb) {
        if (this.failedParsing || this.json == null) {
            super.printContent(sb);
        } else {
            sb.append("JSON: ");
            sb.append(this.json.toPrettyString());
        }
    }
}

