/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.utils.communication.async;

import com.yahoo.vespa.clustercontroller.utils.communication.async.AsyncCallback;
import com.yahoo.vespa.clustercontroller.utils.communication.async.AsyncOperation;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Logger;

public class AsyncOperationListenImpl<T> {
    private static final Logger log = Logger.getLogger(AsyncOperationListenImpl.class.getName());
    private final Collection<AsyncCallback<T>> listeners = new HashSet<AsyncCallback<T>>();
    private boolean listenersNotified = false;
    private final AsyncOperation<T> op;

    protected AsyncOperationListenImpl(AsyncOperation<T> op) {
        this.op = op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(AsyncCallback<T> callback) {
        Collection<AsyncCallback<T>> collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(callback);
            if (this.listenersNotified) {
                callback.done(this.op);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(AsyncCallback<T> callback) {
        Collection<AsyncCallback<T>> collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners() {
        Collection<AsyncCallback<T>> collection = this.listeners;
        synchronized (collection) {
            if (this.listenersNotified) {
                return;
            }
            for (AsyncCallback<T> callback : this.listeners) {
                try {
                    callback.done(this.op);
                }
                catch (RuntimeException e) {
                    StringWriter sw = new StringWriter();
                    e.printStackTrace(new PrintWriter(sw));
                    log.warning("Callback '" + callback + "' threw exception on notify. Should not happen:\n" + sw);
                }
            }
            this.listenersNotified = true;
        }
    }
}

