/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.utils.staterestapi.server;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.yahoo.vespa.clustercontroller.utils.communication.http.HttpRequest;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.errors.InvalidContentException;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.requests.SetUnitStateRequest;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.response.UnitState;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class JsonReader {
    private static final ObjectMapper mapper = new ObjectMapper();

    public SetRequestData getStateRequestData(HttpRequest request) throws Exception {
        JsonNode json = mapper.readTree(request.getPostContent().toString());
        boolean probe = json.has("probe") && json.get("probe").booleanValue();
        SetUnitStateRequest.Condition condition = json.has("condition") ? SetUnitStateRequest.Condition.fromString(json.get("condition").textValue()) : SetUnitStateRequest.Condition.FORCE;
        SetUnitStateRequest.ResponseWait responseWait = json.has("response-wait") ? SetUnitStateRequest.ResponseWait.fromString(json.get("response-wait").textValue()) : SetUnitStateRequest.ResponseWait.WAIT_UNTIL_CLUSTER_ACKED;
        HashMap<String, UnitState> stateMap = new HashMap<String, UnitState>();
        if (!json.has("state")) {
            throw new InvalidContentException("Set state requests must contain a state object");
        }
        JsonNode o = json.get("state");
        if (!(o instanceof ObjectNode)) {
            throw new InvalidContentException("value of state is not a json object");
        }
        ObjectNode state = (ObjectNode)o;
        Iterator fields = state.fields();
        while (fields.hasNext()) {
            Map.Entry entry = (Map.Entry)fields.next();
            String type = (String)entry.getKey();
            Object v = entry.getValue();
            if (!(v instanceof ObjectNode)) {
                throw new InvalidContentException("value of state->" + type + " is not a json object");
            }
            ObjectNode userState = (ObjectNode)v;
            String code = "up";
            if (userState.has("state")) {
                o = userState.get("state");
                if (!o.isTextual()) {
                    throw new InvalidContentException("value of state->" + type + "->state is not a string");
                }
                code = o.textValue();
            }
            String reason = "";
            if (userState.has("reason")) {
                o = userState.get("reason");
                if (!o.isTextual()) {
                    throw new InvalidContentException("value of state->" + type + "->reason is not a string");
                }
                reason = o.textValue();
            }
            stateMap.put(type, new UnitStateImpl(code, reason));
        }
        return new SetRequestData(probe, stateMap, condition, responseWait);
    }

    private static class UnitStateImpl
    implements UnitState {
        private final String id;
        private final String reason;

        public UnitStateImpl(String id, String reason) {
            this.id = id;
            this.reason = reason;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getReason() {
            return this.reason;
        }

        public String toString() {
            return this.getId() + ": " + this.getReason();
        }
    }

    static class SetRequestData {
        final boolean probe;
        final Map<String, UnitState> stateMap;
        final SetUnitStateRequest.Condition condition;
        final SetUnitStateRequest.ResponseWait responseWait;

        public SetRequestData(boolean probe, Map<String, UnitState> stateMap, SetUnitStateRequest.Condition condition, SetUnitStateRequest.ResponseWait responseWait) {
            this.probe = probe;
            this.stateMap = stateMap;
            this.condition = condition;
            this.responseWait = responseWait;
        }
    }
}

