/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.utils.staterestapi.server;

import com.google.common.util.concurrent.UncheckedTimeoutException;
import com.yahoo.time.TimeBudget;
import com.yahoo.vespa.clustercontroller.utils.communication.http.HttpRequest;
import com.yahoo.vespa.clustercontroller.utils.communication.http.HttpRequestHandler;
import com.yahoo.vespa.clustercontroller.utils.communication.http.HttpResult;
import com.yahoo.vespa.clustercontroller.utils.communication.http.JsonHttpResult;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.StateRestAPI;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.errors.DeadlineExceededException;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.errors.InvalidContentException;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.errors.InvalidOptionValueException;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.errors.OtherMasterException;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.errors.StateRestApiException;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.errors.UnknownMasterException;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.requests.SetUnitStateRequest;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.requests.UnitStateRequest;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.response.SetResponse;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.response.UnitResponse;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.response.UnitState;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.server.JsonReader;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.server.JsonWriter;
import com.yahoo.yolean.Exceptions;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RestApiHandler
implements HttpRequestHandler {
    public static final Duration MAX_TIMEOUT = Duration.ofHours(1L);
    private static final Logger log = Logger.getLogger(RestApiHandler.class.getName());
    private final StateRestAPI restApi;
    private final JsonWriter jsonWriter;
    private final JsonReader jsonReader = new JsonReader();
    private final Clock clock;
    private static List<Escape> escapes = new ArrayList<Escape>();

    public RestApiHandler(StateRestAPI restApi) {
        this.restApi = restApi;
        this.jsonWriter = new JsonWriter();
        this.clock = Clock.systemUTC();
    }

    public RestApiHandler setDefaultPathPrefix(String defaultPathPrefix) {
        this.jsonWriter.setDefaultPathPrefix(defaultPathPrefix);
        return this;
    }

    private static void logRequestException(HttpRequest request, Exception exception, Level level) {
        String exceptionString = Exceptions.toMessageString((Throwable)exception);
        log.log(level, "Failed to process request with URI path " + request.getPath() + ": " + exceptionString);
    }

    @Override
    public HttpResult handleRequest(HttpRequest request) {
        final Instant start = this.clock.instant();
        try {
            final String[] unitPath = this.createUnitPath(request);
            if (request.getHttpOperation().equals((Object)HttpRequest.HttpOp.GET)) {
                final int recursiveLevel = this.getRecursiveLevel(request);
                UnitResponse data = this.restApi.getState(new UnitStateRequest(){

                    @Override
                    public int getRecursiveLevels() {
                        return recursiveLevel;
                    }

                    @Override
                    public String[] getUnitPath() {
                        return unitPath;
                    }
                });
                return new JsonHttpResult().setJson(this.jsonWriter.createJson(data));
            }
            final JsonReader.SetRequestData setRequestData = this.jsonReader.getStateRequestData(request);
            final Optional<Duration> timeout = RestApiHandler.parseTimeout(request.getOption("timeout", null));
            SetResponse setResponse = this.restApi.setUnitState(new SetUnitStateRequest(){

                @Override
                public Map<String, UnitState> getNewState() {
                    return setRequestData.stateMap;
                }

                @Override
                public String[] getUnitPath() {
                    return unitPath;
                }

                @Override
                public SetUnitStateRequest.Condition getCondition() {
                    return setRequestData.condition;
                }

                @Override
                public SetUnitStateRequest.ResponseWait getResponseWait() {
                    return setRequestData.responseWait;
                }

                @Override
                public TimeBudget timeBudget() {
                    return TimeBudget.from((Clock)RestApiHandler.this.clock, (Instant)start, (Optional)timeout);
                }

                @Override
                public boolean isProbe() {
                    return setRequestData.probe;
                }
            });
            return new JsonHttpResult().setJson(this.jsonWriter.createJson(setResponse));
        }
        catch (OtherMasterException exception) {
            RestApiHandler.logRequestException(request, exception, Level.FINE);
            JsonHttpResult result = new JsonHttpResult();
            result.setHttpCode(307, "Temporary Redirect");
            result.addHeader("Location", this.getMasterLocationUrl(request, exception.getHost(), exception.getPort()));
            result.setJson(this.jsonWriter.createErrorJson(exception.getMessage()));
            return result;
        }
        catch (UnknownMasterException exception) {
            RestApiHandler.logRequestException(request, exception, Level.WARNING);
            JsonHttpResult result = new JsonHttpResult();
            result.setHttpCode(503, "Service Unavailable");
            result.setJson(this.jsonWriter.createErrorJson(exception.getMessage()));
            return result;
        }
        catch (UncheckedTimeoutException | DeadlineExceededException exception) {
            RestApiHandler.logRequestException(request, (Exception)exception, Level.WARNING);
            JsonHttpResult result = new JsonHttpResult();
            result.setHttpCode(504, "Gateway Timeout");
            result.setJson(this.jsonWriter.createErrorJson(exception.getMessage()));
            return result;
        }
        catch (StateRestApiException exception) {
            RestApiHandler.logRequestException(request, exception, Level.WARNING);
            JsonHttpResult result = new JsonHttpResult();
            result.setHttpCode(500, "Failed to process request");
            if (exception.getStatus() != null) {
                result.setHttpCode(result.getHttpReturnCode(), exception.getStatus());
            }
            if (exception.getCode() != null) {
                result.setHttpCode(exception.getCode(), result.getHttpReturnCodeDescription());
            }
            result.setJson(this.jsonWriter.createErrorJson(exception.getMessage()));
            return result;
        }
        catch (Exception exception) {
            RestApiHandler.logRequestException(request, exception, Level.SEVERE);
            JsonHttpResult result = new JsonHttpResult();
            result.setHttpCode(500, "Failed to process request");
            result.setJson(this.jsonWriter.createErrorJson(exception.getClass().getName() + ": " + exception.getMessage()));
            return result;
        }
    }

    private String[] createUnitPath(HttpRequest request) {
        List<String> path = Arrays.asList(request.getPath().split("/"));
        return path.subList(3, path.size()).toArray(new String[0]);
    }

    private int getRecursiveLevel(HttpRequest request) throws StateRestApiException {
        int level;
        String val = request.getOption("recursive", "false");
        if (val.toLowerCase().equals("false")) {
            return 0;
        }
        if (val.toLowerCase().equals("true")) {
            return Integer.MAX_VALUE;
        }
        try {
            level = Integer.parseInt(val);
            if (level < 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            throw new InvalidOptionValueException("recursive", val, "Recursive option must be true, false, 0 or a positive integer");
        }
        return level;
    }

    private String getMasterLocationUrl(HttpRequest request, String host, int port) {
        StringBuilder sb = new StringBuilder();
        sb.append(request.getScheme()).append("://").append(host).append(':').append(port).append(request.getPath());
        if (!request.getUrlOptions().isEmpty()) {
            boolean first = true;
            for (HttpRequest.KeyValuePair kvp : request.getUrlOptions()) {
                sb.append(first ? (char)'?' : '&');
                first = false;
                sb.append(RestApiHandler.httpEscape(kvp.getKey())).append('=').append(RestApiHandler.httpEscape(kvp.getValue()));
            }
        }
        return sb.toString();
    }

    private static String httpEscape(String value) {
        for (Escape e : escapes) {
            value = value.replaceAll(e.pattern, e.replaceWith);
        }
        return value;
    }

    static Optional<Duration> parseTimeout(String timeoutOption) throws InvalidContentException {
        float timeoutSeconds;
        if (timeoutOption == null) {
            return Optional.empty();
        }
        try {
            timeoutSeconds = Float.parseFloat(timeoutOption);
        }
        catch (NumberFormatException e) {
            throw new InvalidContentException("value of timeout->" + timeoutOption + " is not a float");
        }
        if ((double)timeoutSeconds <= 0.0) {
            return Optional.of(Duration.ZERO);
        }
        if (timeoutSeconds <= (float)MAX_TIMEOUT.getSeconds()) {
            return Optional.of(Duration.ofMillis(Math.round(timeoutSeconds * 1000.0f)));
        }
        throw new InvalidContentException("value of timeout->" + timeoutOption + " exceeds max timeout " + MAX_TIMEOUT);
    }

    static {
        escapes.add(new Escape("%", "%25"));
        escapes.add(new Escape(" ", "%20"));
        escapes.add(new Escape("\\?", "%3F"));
        escapes.add(new Escape("=", "%3D"));
        escapes.add(new Escape("\\&", "%26"));
    }

    private static class Escape {
        public final String pattern;
        public final String replaceWith;

        public Escape(String pat, String repl) {
            this.pattern = pat;
            this.replaceWith = repl;
        }
    }
}

