/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.utils.staterestapi.server;

import com.yahoo.vespa.clustercontroller.utils.staterestapi.response.CurrentUnitState;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.response.DistributionState;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.response.DistributionStates;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.response.SetResponse;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.response.SubUnitList;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.response.UnitAttributes;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.response.UnitMetrics;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.response.UnitResponse;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.response.UnitState;
import java.util.Map;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class JsonWriter {
    private String pathPrefix = "/";

    public void setDefaultPathPrefix(String defaultPathPrefix) {
        if (defaultPathPrefix.isEmpty() || defaultPathPrefix.charAt(0) != '/') {
            throw new IllegalArgumentException("Path prefix must start with a slash");
        }
        this.pathPrefix = defaultPathPrefix;
    }

    public JSONObject createJson(UnitResponse data) throws Exception {
        JSONObject json = new JSONObject();
        this.fillInJson(data, json);
        return json;
    }

    public void fillInJson(UnitResponse data, JSONObject json) throws Exception {
        DistributionStates distributionStates;
        Map<String, SubUnitList> subUnits;
        UnitMetrics metrics;
        CurrentUnitState stateData;
        UnitAttributes attributes = data.getAttributes();
        if (attributes != null) {
            this.fillInJson(attributes, json);
        }
        if ((stateData = data.getCurrentState()) != null) {
            this.fillInJson(stateData, json);
        }
        if ((metrics = data.getMetrics()) != null) {
            this.fillInJson(metrics, json);
        }
        if ((subUnits = data.getSubUnits()) != null) {
            this.fillInJson(subUnits, json);
        }
        if ((distributionStates = data.getDistributionStates()) != null) {
            JsonWriter.fillInJson(distributionStates, json);
        }
    }

    public void fillInJson(CurrentUnitState stateData, JSONObject json) throws Exception {
        JSONObject stateJson = new JSONObject();
        json.put("state", (Object)stateJson);
        Map<String, UnitState> state = stateData.getStatePerType();
        for (Map.Entry<String, UnitState> e : state.entrySet()) {
            String stateType = e.getKey();
            UnitState unitState = e.getValue();
            JSONObject stateTypeJson = new JSONObject().put("state", (Object)unitState.getId()).put("reason", (Object)unitState.getReason());
            stateJson.put(stateType, (Object)stateTypeJson);
        }
    }

    public void fillInJson(UnitMetrics metrics, JSONObject json) throws Exception {
        JSONObject metricsJson = new JSONObject();
        for (Map.Entry<String, Number> e : metrics.getMetricMap().entrySet()) {
            metricsJson.put(e.getKey(), (Object)e.getValue());
        }
        json.put("metrics", (Object)metricsJson);
    }

    public void fillInJson(UnitAttributes attributes, JSONObject json) throws Exception {
        JSONObject attributesJson = new JSONObject();
        for (Map.Entry<String, String> e : attributes.getAttributeValues().entrySet()) {
            attributesJson.put(e.getKey(), (Object)e.getValue());
        }
        json.put("attributes", (Object)attributesJson);
    }

    public void fillInJson(Map<String, SubUnitList> subUnitMap, JSONObject json) throws Exception {
        for (Map.Entry<String, SubUnitList> e : subUnitMap.entrySet()) {
            String subUnitType = e.getKey();
            JSONObject typeJson = new JSONObject();
            for (Map.Entry<String, String> entry : e.getValue().getSubUnitLinks().entrySet()) {
                JSONObject linkJson = new JSONObject();
                linkJson.put("link", (Object)(this.pathPrefix + "/" + entry.getValue()));
                typeJson.put(entry.getKey(), (Object)linkJson);
            }
            for (Map.Entry<String, Object> entry : e.getValue().getSubUnits().entrySet()) {
                JSONObject subJson = new JSONObject();
                this.fillInJson((UnitResponse)entry.getValue(), subJson);
                typeJson.put(entry.getKey(), (Object)subJson);
            }
            json.put(subUnitType, (Object)typeJson);
        }
    }

    private static void fillInJson(DistributionStates states, JSONObject json) throws Exception {
        JSONObject statesJson = new JSONObject();
        statesJson.put("published", (Object)JsonWriter.distributionStateToJson(states.getPublishedState()));
        json.put("distribution-states", (Object)statesJson);
    }

    private static JSONObject distributionStateToJson(DistributionState state) throws Exception {
        JSONObject result = new JSONObject();
        result.put("baseline", (Object)state.getBaselineState());
        JSONArray bucketSpacesJson = new JSONArray();
        for (Map.Entry<String, String> entry : state.getBucketSpaceStates().entrySet()) {
            JSONObject bucketSpaceJson = new JSONObject();
            bucketSpaceJson.put("name", (Object)entry.getKey());
            bucketSpaceJson.put("state", (Object)entry.getValue());
            bucketSpacesJson.put((Object)bucketSpaceJson);
        }
        result.put("bucket-spaces", (Object)bucketSpacesJson);
        return result;
    }

    public JSONObject createErrorJson(String description) {
        JSONObject o = new JSONObject();
        try {
            o.put("message", (Object)description);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return o;
    }

    public JSONObject createJson(SetResponse setResponse) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("wasModified", setResponse.getWasModified());
        jsonObject.put("reason", (Object)setResponse.getReason());
        return jsonObject;
    }
}

