/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.utils.communication.http.writer;

public class HttpWriter {
    private final StringBuilder builder = new StringBuilder();
    private String title = "Untitled page";
    private State state = State.HEADER;

    public HttpWriter addTitle(String title) {
        this.verifyState(State.HEADER);
        this.title = title;
        return this;
    }

    public HttpWriter write(String paragraph) {
        this.verifyState(State.BODY);
        this.builder.append("    <p>\n").append("      " + paragraph + "\n").append("    </p>\n");
        return this;
    }

    public HttpWriter writeLink(String name, String link) {
        this.verifyState(State.BODY);
        this.builder.append("    <a href=\"" + link + "\">" + name + "</a>\n");
        return this;
    }

    private void verifyState(State state) {
        if (this.state == state) {
            return;
        }
        if (state != State.FINALIZED && this.state == State.FINALIZED) {
            throw new IllegalStateException("HTTP page already finalized");
        }
        if (state == State.HEADER && this.state == State.BODY) {
            throw new IllegalStateException("Have already started to write body. Cannot alter header");
        }
        if (this.state == State.HEADER) {
            this.builder.append("<html>\n  <head>\n    <title>" + this.title + "</title>\n  </head>\n  <body>\n    <h1>" + this.title + "</h1>\n");
            this.state = State.BODY;
            if (this.state == state) {
                return;
            }
        }
        this.builder.append("  </body>\n</html>\n");
        this.state = State.FINALIZED;
    }

    public String toString() {
        this.verifyState(State.FINALIZED);
        return this.builder.toString();
    }

    static enum State {
        HEADER,
        BODY,
        FINALIZED;

    }
}

