/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.utils.communication.http;

import com.yahoo.vespa.clustercontroller.utils.communication.async.AsyncOperation;
import com.yahoo.vespa.clustercontroller.utils.communication.http.AsyncHttpClient;
import com.yahoo.vespa.clustercontroller.utils.communication.http.AsyncHttpClientWithBase;
import com.yahoo.vespa.clustercontroller.utils.communication.http.HttpRequest;
import com.yahoo.vespa.clustercontroller.utils.communication.http.HttpResult;

public class ProxyAsyncHttpClient<V extends HttpResult>
extends AsyncHttpClientWithBase<V> {
    private final String proxyHost;
    private final int proxyPort;

    public ProxyAsyncHttpClient(AsyncHttpClient<V> client, String proxyHost, int proxyPort) {
        super(client);
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
    }

    @Override
    public AsyncOperation<V> execute(HttpRequest r) {
        r = this.getHttpRequestBase().merge(r);
        if (r.getHost() == null || r.getPath() == null) {
            throw new IllegalStateException("Host and path must be set prior to being able to proxy an HTTP request");
        }
        StringBuilder path = new StringBuilder().append(r.getHost());
        if (r.getPort() != 0) {
            path.append(':').append(r.getPort());
        }
        if (r.getPath().isEmpty() || r.getPath().charAt(0) != '/') {
            path.append('/');
        }
        path.append(r.getPath());
        return this.client.execute(r.setHost(this.proxyHost).setPort(this.proxyPort).setPath(path.toString()));
    }
}

