/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.utils.communication.http;

import com.yahoo.vespa.clustercontroller.utils.communication.async.AsyncOperation;
import com.yahoo.vespa.clustercontroller.utils.communication.async.RedirectedAsyncOperation;
import com.yahoo.vespa.clustercontroller.utils.communication.http.AsyncHttpClient;
import com.yahoo.vespa.clustercontroller.utils.communication.http.HttpRequest;
import com.yahoo.vespa.clustercontroller.utils.communication.http.HttpResult;
import com.yahoo.vespa.clustercontroller.utils.communication.http.JsonHttpResult;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class JsonAsyncHttpClient
implements AsyncHttpClient<JsonHttpResult> {
    private AsyncHttpClient<HttpResult> client;
    private boolean verifyRequestContentAsJson = true;
    private boolean addJsonContentType = true;

    public JsonAsyncHttpClient(AsyncHttpClient<HttpResult> client) {
        this.client = client;
    }

    public JsonAsyncHttpClient verifyRequestContentAsJson(boolean doIt) {
        this.verifyRequestContentAsJson = doIt;
        return this;
    }

    public JsonAsyncHttpClient addJsonContentType(boolean doIt) {
        this.addJsonContentType = doIt;
        return this;
    }

    @Override
    public AsyncOperation<JsonHttpResult> execute(HttpRequest r) {
        if (this.verifyRequestContentAsJson && r.getPostContent() != null && !(r.getPostContent() instanceof JSONObject)) {
            try {
                r = r.clone().setPostContent(new JSONObject(r.getPostContent().toString()));
            }
            catch (JSONException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (this.addJsonContentType && r.getPostContent() != null) {
            r = r.clone().addHttpHeader("Content-Type", "application/json");
        }
        final AsyncOperation<HttpResult> op = this.client.execute(r);
        return new RedirectedAsyncOperation<HttpResult, JsonHttpResult>(op){

            @Override
            public JsonHttpResult getResult() {
                return op.getResult() == null ? null : new JsonHttpResult((HttpResult)op.getResult());
            }
        };
    }

    @Override
    public void close() {
        this.client.close();
    }
}

