/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.utils.staterestapi.requests;

import com.yahoo.time.TimeBudget;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.errors.InvalidContentException;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.requests.UnitRequest;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.response.UnitState;
import java.util.Map;

public interface SetUnitStateRequest
extends UnitRequest {
    public Map<String, UnitState> getNewState();

    public Condition getCondition();

    public ResponseWait getResponseWait();

    public TimeBudget timeBudget();

    public static enum ResponseWait {
        WAIT_UNTIL_CLUSTER_ACKED("wait-until-cluster-acked"),
        NO_WAIT("no-wait");

        private final String name;

        private ResponseWait(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public static ResponseWait fromString(String value) throws InvalidContentException {
            if (value.equalsIgnoreCase(ResponseWait.WAIT_UNTIL_CLUSTER_ACKED.name)) {
                return WAIT_UNTIL_CLUSTER_ACKED;
            }
            if (value.equalsIgnoreCase(ResponseWait.NO_WAIT.name)) {
                return NO_WAIT;
            }
            throw new InvalidContentException(String.format("Invalid value for response-wait: '%s', expected one of '%s', '%s'", value, ResponseWait.WAIT_UNTIL_CLUSTER_ACKED.name, ResponseWait.NO_WAIT.name));
        }
    }

    public static enum Condition {
        FORCE(1),
        SAFE(2);

        public final int value;

        private Condition(int value) {
            this.value = value;
        }

        public static Condition fromString(String value) throws InvalidContentException {
            try {
                return Condition.valueOf(value.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new InvalidContentException(String.format("Invalid value for condition: '%s', expected one of 'force', 'safe'", value));
            }
        }
    }
}

