/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.utils.communication.http;

import com.yahoo.vespa.clustercontroller.utils.communication.async.AsyncCallback;
import com.yahoo.vespa.clustercontroller.utils.communication.async.AsyncOperation;
import com.yahoo.vespa.clustercontroller.utils.communication.http.AsyncHttpClient;
import com.yahoo.vespa.clustercontroller.utils.communication.http.HttpRequest;
import com.yahoo.vespa.clustercontroller.utils.communication.http.HttpResult;
import java.util.LinkedList;
import java.util.logging.Logger;

public class RequestQueue<V extends HttpResult> {
    private static final Logger log = Logger.getLogger(RequestQueue.class.getName());
    private final AsyncHttpClient<V> httpClient;
    private final LinkedList<Request<V>> requestQueue = new LinkedList();
    private final int maxPendingRequests;
    private int pendingRequests = 0;

    public RequestQueue(AsyncHttpClient<V> httpClient, int maxPendingRequests) {
        this.httpClient = httpClient;
        this.maxPendingRequests = maxPendingRequests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean empty() {
        LinkedList<Request<V>> linkedList = this.requestQueue;
        synchronized (linkedList) {
            return this.requestQueue.isEmpty() && this.pendingRequests == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilEmpty() throws InterruptedException {
        LinkedList<Request<V>> linkedList = this.requestQueue;
        synchronized (linkedList) {
            while (!this.empty()) {
                this.requestQueue.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(HttpRequest request, AsyncCallback<V> callback) {
        log.fine("Scheduling " + request + " call");
        LinkedList<Request<V>> linkedList = this.requestQueue;
        synchronized (linkedList) {
            this.requestQueue.addLast(new Request<V>(request, callback));
            this.sendMore();
        }
    }

    private void sendMore() {
        while (this.pendingRequests < this.maxPendingRequests && !this.requestQueue.isEmpty()) {
            Request<V> call = this.requestQueue.removeFirst();
            log.fine("Sending " + call.getRequest() + ".");
            ++this.pendingRequests;
            AsyncOperation<V> op = this.httpClient.execute(call.getRequest());
            op.register(call);
        }
    }

    private class Request<V extends HttpResult>
    implements AsyncCallback<V> {
        private final HttpRequest request;
        private final AsyncCallback<V> callback;

        Request(HttpRequest request, AsyncCallback<V> callback) {
            this.request = request;
            this.callback = callback;
        }

        public HttpRequest getRequest() {
            return this.request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void done(AsyncOperation<V> op) {
            if (op.isSuccess()) {
                log.fine("Operation " + op.getName() + " completed successfully");
            } else {
                log.fine("Operation " + op.getName() + " failed: " + op.getCause());
            }
            LinkedList linkedList = RequestQueue.this.requestQueue;
            synchronized (linkedList) {
                --RequestQueue.this.pendingRequests;
            }
            this.callback.done(op);
            linkedList = RequestQueue.this.requestQueue;
            synchronized (linkedList) {
                RequestQueue.this.requestQueue.notifyAll();
                RequestQueue.this.sendMore();
            }
        }
    }
}

