/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.utils.communication.http;

import com.yahoo.vespa.clustercontroller.utils.communication.async.AsyncOperation;
import com.yahoo.vespa.clustercontroller.utils.communication.http.AsyncHttpClient;
import com.yahoo.vespa.clustercontroller.utils.communication.http.HttpRequest;
import com.yahoo.vespa.clustercontroller.utils.communication.http.HttpResult;

public class AsyncHttpClientWithBase<V extends HttpResult>
implements AsyncHttpClient<V> {
    protected final AsyncHttpClient<V> client;
    private HttpRequest baseRequest = new HttpRequest();

    public AsyncHttpClientWithBase(AsyncHttpClient<V> client) {
        if (client == null) {
            throw new IllegalArgumentException("HTTP client must be set.");
        }
        this.client = client;
    }

    public void setHttpRequestBase(HttpRequest r) {
        this.baseRequest = r == null ? new HttpRequest() : r.clone();
    }

    public HttpRequest getHttpRequestBase() {
        return this.baseRequest;
    }

    @Override
    public AsyncOperation<V> execute(HttpRequest r) {
        return this.client.execute(this.baseRequest.merge(r));
    }

    @Override
    public void close() {
        this.client.close();
    }
}

