/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.apps.clustercontroller;

import com.yahoo.cloud.config.ClusterInfoConfig;
import com.yahoo.component.annotation.Inject;
import com.yahoo.container.jdisc.RequestView;
import com.yahoo.container.jdisc.ThreadedHttpRequestHandler;
import com.yahoo.container.jdisc.utils.CapabilityRequiringRequestHandler;
import com.yahoo.security.tls.Capability;
import com.yahoo.vespa.clustercontroller.apps.clustercontroller.ClusterController;
import com.yahoo.vespa.clustercontroller.apputil.communication.http.JDiscHttpRequestHandler;
import com.yahoo.vespa.clustercontroller.core.restapiv2.ClusterControllerStateRestAPI;
import com.yahoo.vespa.clustercontroller.utils.communication.http.HttpRequestHandler;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.StateRestAPI;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.server.RestApiHandler;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StateRestApiV2Handler
extends JDiscHttpRequestHandler
implements CapabilityRequiringRequestHandler {
    private static final Logger log = Logger.getLogger(StateRestApiV2Handler.class.getName());

    @Inject
    public StateRestApiV2Handler(ClusterController cc, ClusterInfoConfig config, ThreadedHttpRequestHandler.Context ctx) {
        this(new ClusterControllerStateRestAPI((ClusterControllerStateRestAPI.FleetControllerResolver)cc, StateRestApiV2Handler.getClusterControllerSockets(config)), "/cluster/v2", ctx);
    }

    public Capability requiredCapability(RequestView __) {
        return Capability.CLUSTER_CONTROLLER__STATE;
    }

    private StateRestApiV2Handler(ClusterControllerStateRestAPI restApi, String pathPrefix, ThreadedHttpRequestHandler.Context ctx) {
        super((HttpRequestHandler)new RestApiHandler((StateRestAPI)restApi).setDefaultPathPrefix(pathPrefix), ctx);
    }

    static Map<Integer, ClusterControllerStateRestAPI.Socket> getClusterControllerSockets(ClusterInfoConfig config) {
        TreeMap<Integer, ClusterControllerStateRestAPI.Socket> result = new TreeMap<Integer, ClusterControllerStateRestAPI.Socket>();
        block0: for (ClusterInfoConfig.Services service : config.services()) {
            for (ClusterInfoConfig.Services.Ports port : service.ports()) {
                Set<String> tags = StateRestApiV2Handler.parseTags(port.tags());
                if (!tags.contains("http") || !tags.contains("state")) continue;
                result.put(service.index(), new ClusterControllerStateRestAPI.Socket(service.hostname(), port.number()));
                continue block0;
            }
        }
        if (result.isEmpty()) {
            log.warning("Found no cluster controller in model config");
        } else if (log.isLoggable(Level.FINE)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Found ").append(result.size()).append(" cluster controllers in model config:");
            for (Map.Entry e : result.entrySet()) {
                sb.append("\n  ").append(e.getKey()).append(" -> ").append(e.getValue());
            }
            log.fine(sb.toString());
        }
        return result;
    }

    private static Set<String> parseTags(String tags) {
        HashSet<String> set = new HashSet<String>();
        for (String s : tags.toLowerCase().split(" ")) {
            set.add(s.trim());
        }
        return set;
    }
}

