/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.apps.clustercontroller;

import com.yahoo.component.AbstractComponent;
import com.yahoo.component.annotation.Inject;
import com.yahoo.jdisc.Metric;
import com.yahoo.vespa.clustercontroller.apputil.communication.http.JDiscMetricWrapper;
import com.yahoo.vespa.clustercontroller.core.FleetController;
import com.yahoo.vespa.clustercontroller.core.FleetControllerOptions;
import com.yahoo.vespa.clustercontroller.core.RemoteClusterControllerTaskScheduler;
import com.yahoo.vespa.clustercontroller.core.restapiv2.ClusterControllerStateRestAPI;
import com.yahoo.vespa.clustercontroller.core.status.StatusHandler;
import com.yahoo.vespa.clustercontroller.utils.util.MetricReporter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;

public class ClusterController
extends AbstractComponent
implements ClusterControllerStateRestAPI.FleetControllerResolver,
StatusHandler.ClusterStatusPageServerSet {
    private static final Logger log = Logger.getLogger(ClusterController.class.getName());
    private final JDiscMetricWrapper metricWrapper;
    private final Object monitor = new Object();
    private final Map<String, FleetController> controllers = new TreeMap<String, FleetController>();
    private final Map<String, StatusHandler.ContainerStatusPageServer> status = new TreeMap<String, StatusHandler.ContainerStatusPageServer>();
    private final Map<String, Integer> referents = new HashMap<String, Integer>();
    private final AtomicBoolean shutdown = new AtomicBoolean();

    @Inject
    public ClusterController() {
        this.metricWrapper = new JDiscMetricWrapper(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOptions(FleetControllerOptions options, Metric metricImpl) throws Exception {
        this.metricWrapper.updateMetricImplementation(metricImpl);
        Object object = this.monitor;
        synchronized (object) {
            this.referents.merge(options.clusterName(), 1, Integer::sum);
            FleetController controller = this.controllers.get(options.clusterName());
            if (controller == null) {
                controller = FleetController.create((FleetControllerOptions)options, (MetricReporter)this.metricWrapper);
                this.controllers.put(options.clusterName(), controller);
                this.status.put(options.clusterName(), controller.statusPageServer());
            } else {
                controller.updateOptions(options);
            }
        }
    }

    public void deconstruct() {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void countdown(String clusterName) {
        Object object = this.monitor;
        synchronized (object) {
            this.referents.compute(clusterName, (__, count) -> {
                if (count == null) {
                    throw new IllegalStateException("trying to remove unknown cluster: " + clusterName);
                }
                if (count == 1) {
                    this.shutDownController(this.controllers.remove(clusterName));
                    this.status.remove(clusterName);
                    return null;
                }
                return count - 1;
            });
        }
    }

    private void shutDownController(FleetController controller) {
        if (controller == null) {
            return;
        }
        try {
            controller.shutdown();
        }
        catch (Exception e) {
            log.warning("Failed to shut down fleet controller: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        if (this.shutdown.compareAndSet(false, true)) {
            Object object = this.monitor;
            synchronized (object) {
                for (FleetController controller : this.controllers.values()) {
                    this.shutDownController(controller);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, RemoteClusterControllerTaskScheduler> getFleetControllers() {
        Object object = this.monitor;
        synchronized (object) {
            return new LinkedHashMap<String, FleetController>(this.controllers);
        }
    }

    public StatusHandler.ContainerStatusPageServer get(String cluster) {
        return this.status.get(cluster);
    }

    public Map<String, StatusHandler.ContainerStatusPageServer> getAll() {
        return this.status;
    }
}

