/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.apps.clustercontroller;

import com.google.inject.Inject;
import com.yahoo.component.AbstractComponent;
import com.yahoo.jdisc.Metric;
import com.yahoo.vespa.clustercontroller.apputil.communication.http.JDiscMetricWrapper;
import com.yahoo.vespa.clustercontroller.core.FleetController;
import com.yahoo.vespa.clustercontroller.core.FleetControllerOptions;
import com.yahoo.vespa.clustercontroller.core.RemoteClusterControllerTaskScheduler;
import com.yahoo.vespa.clustercontroller.core.restapiv2.ClusterControllerStateRestAPI;
import com.yahoo.vespa.clustercontroller.core.status.StatusHandler;
import com.yahoo.vespa.clustercontroller.core.status.statuspage.StatusPageServerInterface;
import com.yahoo.vespa.clustercontroller.utils.util.MetricReporter;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.zookeeper.VespaZooKeeperServer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;

public class ClusterController
extends AbstractComponent
implements ClusterControllerStateRestAPI.FleetControllerResolver,
StatusHandler.ClusterStatusPageServerSet {
    private static final Logger log = Logger.getLogger(ClusterController.class.getName());
    private final JDiscMetricWrapper metricWrapper;
    private final Map<String, FleetController> controllers = new TreeMap<String, FleetController>();
    private final Map<String, StatusHandler.ContainerStatusPageServer> status = new TreeMap<String, StatusHandler.ContainerStatusPageServer>();

    @Inject
    public ClusterController(VespaZooKeeperServer ignored) {
        this();
    }

    ClusterController() {
        this.metricWrapper = new JDiscMetricWrapper(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOptions(FleetControllerOptions options, Metric metricImpl) throws Exception {
        this.metricWrapper.updateMetricImplementation(metricImpl);
        this.verifyThatZooKeeperWorks(options);
        Map<String, FleetController> map = this.controllers;
        synchronized (map) {
            FleetController controller = this.controllers.get(options.clusterName);
            if (controller == null) {
                StatusHandler.ContainerStatusPageServer statusPageServer = new StatusHandler.ContainerStatusPageServer();
                controller = FleetController.create((FleetControllerOptions)options, (StatusPageServerInterface)statusPageServer, (MetricReporter)this.metricWrapper);
                this.controllers.put(options.clusterName, controller);
                this.status.put(options.clusterName, statusPageServer);
            } else {
                controller.updateOptions(options, 0L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deconstruct() {
        Map<String, FleetController> map = this.controllers;
        synchronized (map) {
            for (FleetController controller : this.controllers.values()) {
                try {
                    this.shutdownController(controller);
                }
                catch (Exception e) {
                    log.warning("Failed to shut down fleet controller: " + e.getMessage());
                }
            }
        }
        super.deconstruct();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, RemoteClusterControllerTaskScheduler> getFleetControllers() {
        Map<String, FleetController> map = this.controllers;
        synchronized (map) {
            return new LinkedHashMap<String, FleetController>(this.controllers);
        }
    }

    public StatusHandler.ContainerStatusPageServer get(String cluster) {
        return this.status.get(cluster);
    }

    public Map<String, StatusHandler.ContainerStatusPageServer> getAll() {
        return this.status;
    }

    void shutdownController(FleetController controller) throws Exception {
        controller.shutdown();
    }

    private void verifyThatZooKeeperWorks(FleetControllerOptions options) throws Exception {
        if (options.zooKeeperServerAddress != null && !"".equals(options.zooKeeperServerAddress)) {
            Curator curator = Curator.create((String)options.zooKeeperServerAddress);
            curator.framework().blockUntilConnected();
        }
    }
}

