/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.hosted.cd.impl.http;

import ai.vespa.hosted.api.EndpointAuthenticator;
import ai.vespa.hosted.cd.Deployment;
import ai.vespa.hosted.cd.Endpoint;
import ai.vespa.hosted.cd.impl.http.HttpEndpoint;
import java.net.URI;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;

public class HttpDeployment
implements Deployment {
    private final Map<String, Endpoint> endpoints;

    public HttpDeployment(Map<String, URI> endpoints, EndpointAuthenticator authenticator) {
        this.endpoints = endpoints.entrySet().stream().collect(Collectors.toUnmodifiableMap(entry -> (String)entry.getKey(), entry -> new HttpEndpoint((URI)entry.getValue(), authenticator)));
    }

    public Endpoint endpoint(String id) {
        if (!this.endpoints.containsKey(id)) {
            throw new NoSuchElementException("No cluster with id '" + id + "'");
        }
        return this.endpoints.get(id);
    }
}

