/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.client.dsl;

import ai.vespa.client.dsl.A;
import ai.vespa.client.dsl.Annotation;
import ai.vespa.client.dsl.QueryChain;
import ai.vespa.client.dsl.Sources;
import ai.vespa.client.dsl.Text;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;

public class UserInput
extends QueryChain {
    private final Annotation annotation;
    private final String value;
    private final String indexField;
    private String placeholder;
    private boolean setDefaultIndex;

    UserInput(Sources sources, String value) {
        this(sources, A.empty(), value);
    }

    UserInput(Sources sources, Annotation annotation, String value) {
        this.sources = sources;
        this.annotation = annotation;
        this.value = value;
        this.nonEmpty = true;
        if (annotation.contains("defaultIndex")) {
            this.setDefaultIndex = true;
            this.indexField = (String)annotation.get("defaultIndex");
        } else {
            this.indexField = UUID.randomUUID().toString().substring(0, 5);
        }
    }

    UserInput(String value) {
        this(A.empty(), value);
    }

    UserInput(Annotation annotation, String value) {
        this(null, annotation, value);
    }

    @Override
    public void setIndex(int index) {
        this.placeholder = this.setDefaultIndex ? "_" + index + "_" + this.indexField : "_" + index;
    }

    public String toString() {
        return this.setDefaultIndex ? Text.format("([%s]userInput(@%s))", this.annotation, this.placeholder) : Text.format("userInput(@%s)", this.placeholder);
    }

    Map<String, String> getParam() {
        return Collections.singletonMap(this.placeholder, this.value);
    }

    @Override
    boolean hasPositiveSearchField(String fieldName) {
        return !"andnot".equals(this.op) && this.indexField.equals(fieldName);
    }

    @Override
    boolean hasPositiveSearchField(String fieldName, Object value) {
        return this.hasPositiveSearchField(fieldName) && this.value.equals(value);
    }

    @Override
    boolean hasNegativeSearchField(String fieldName) {
        return "andnot".equals(this.op) && this.indexField.equals(fieldName);
    }

    @Override
    boolean hasNegativeSearchField(String fieldName, Object value) {
        return this.hasNegativeSearchField(fieldName) && this.value.equals(value);
    }
}

