/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.client.dsl;

import ai.vespa.client.dsl.A;
import ai.vespa.client.dsl.Annotation;
import ai.vespa.client.dsl.EndQuery;
import ai.vespa.client.dsl.Field;
import ai.vespa.client.dsl.FixedQuery;
import ai.vespa.client.dsl.Group;
import ai.vespa.client.dsl.QueryChain;
import ai.vespa.client.dsl.Select;
import ai.vespa.client.dsl.Sources;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class Query
extends QueryChain {
    final List<QueryChain> queries = new ArrayList<QueryChain>();
    private Annotation annotation;
    private Sources sources;

    Query(Sources sources, QueryChain queryChain) {
        this.sources = sources;
        this.queries.add(queryChain);
        this.nonEmpty = queryChain.nonEmpty;
    }

    Query(Sources sources) {
        this.sources = sources;
    }

    String toCommaSeparatedAndQueries() {
        return this.queries.stream().filter(qc -> "and".equals(qc.getOp())).map(Objects::toString).collect(Collectors.joining(", "));
    }

    public String toString() {
        if (!this.nonEmpty) {
            return "";
        }
        boolean hasAnnotation = A.hasAnnotation(this.annotation);
        StringBuilder sb = new StringBuilder();
        if (hasAnnotation) {
            sb.append("([").append(this.annotation).append("](");
        }
        boolean firstQuery = true;
        for (int i = 0; i < this.queries.size(); ++i) {
            boolean appendBrackets;
            QueryChain qc = this.queries.get(i);
            if (!qc.nonEmpty) continue;
            boolean isNotAnd = "andnot".equals(qc.getOp());
            if (!firstQuery) {
                sb.append(" ");
                if (isNotAnd) {
                    sb.append("and !");
                } else {
                    sb.append(qc.getOp()).append(' ');
                }
            } else {
                firstQuery = false;
            }
            boolean bl = appendBrackets = qc instanceof Query && ((Query)qc).queries.size() > 1 && !A.hasAnnotation(((Query)qc).annotation) || isNotAnd;
            if (appendBrackets) {
                sb.append("(");
            }
            sb.append(qc);
            if (!appendBrackets) continue;
            sb.append(")");
        }
        if (hasAnnotation) {
            sb.append("))");
        }
        return sb.toString().trim();
    }

    public Field and(String fieldName) {
        Field f = new Field(this, fieldName);
        f.setOp("and");
        this.queries.add(f);
        this.nonEmpty = true;
        return f;
    }

    public Field andnot(String fieldName) {
        Field f = new Field(this, fieldName);
        f.setOp("andnot");
        this.queries.add(f);
        this.nonEmpty = true;
        return f;
    }

    public Field or(String fieldName) {
        Field f = new Field(this, fieldName);
        f.setOp("or");
        this.queries.add(f);
        this.nonEmpty = true;
        return f;
    }

    public Query and(QueryChain query) {
        query.setOp("and");
        this.queries.add(query);
        this.nonEmpty = this.nonEmpty || query.nonEmpty;
        return this;
    }

    public Query andnot(QueryChain query) {
        query.setOp("andnot");
        this.queries.add(query);
        this.nonEmpty = this.nonEmpty || query.nonEmpty;
        return this;
    }

    public Query or(QueryChain query) {
        query.setOp("or");
        this.queries.add(query);
        this.nonEmpty = this.nonEmpty || query.nonEmpty;
        return this;
    }

    public Query annotate(Annotation annotation) {
        this.annotation = annotation;
        return this;
    }

    public EndQuery offset(int offset) {
        return new EndQuery(this).offset(offset);
    }

    public EndQuery limit(int hits) {
        return new EndQuery(this).limit(hits);
    }

    public EndQuery timeout(int timeout) {
        return new EndQuery(this).timeout(timeout);
    }

    public EndQuery group(Group group) {
        return new EndQuery(this).group(group);
    }

    public EndQuery group(String groupStr) {
        return new EndQuery(this).group(groupStr);
    }

    public EndQuery orderByAsc(String fieldName) {
        return new EndQuery(this).orderByAsc(fieldName);
    }

    public EndQuery orderByAsc(Annotation annotation, String fieldName) {
        return new EndQuery(this).orderByAsc(annotation, fieldName);
    }

    public EndQuery orderByDesc(String fieldName) {
        return new EndQuery(this).orderByDesc(fieldName);
    }

    public EndQuery orderByDesc(Annotation annotation, String fieldName) {
        return new EndQuery(this).orderByDesc(annotation, fieldName);
    }

    public FixedQuery semicolon() {
        return new FixedQuery(new EndQuery(this));
    }

    @Override
    public Sources getSources() {
        return this.sources;
    }

    @Override
    public void setSources(Sources sources) {
        this.sources = sources;
    }

    @Override
    public Query getQuery() {
        return this;
    }

    @Override
    public Select getSelect() {
        return this.sources.select;
    }

    @Override
    public boolean hasPositiveSearchField(String fieldName) {
        boolean hasPositiveInSubqueries = this.queries.stream().anyMatch(q -> q.hasPositiveSearchField(fieldName));
        boolean hasNegativeInSubqueries = this.queries.stream().anyMatch(q -> q.hasNegativeSearchField(fieldName));
        return this.nonEmpty && (!"andnot".equals(this.op) && hasPositiveInSubqueries || "andnot".equals(this.op) && hasNegativeInSubqueries);
    }

    @Override
    public boolean hasPositiveSearchField(String fieldName, Object value) {
        boolean hasPositiveInSubqueries = this.queries.stream().anyMatch(q -> q.hasPositiveSearchField(fieldName, value));
        boolean hasNegativeInSubqueries = this.queries.stream().anyMatch(q -> q.hasNegativeSearchField(fieldName, value));
        return this.nonEmpty && !"andnot".equals(this.op) && hasPositiveInSubqueries || "andnot".equals(this.op) && hasNegativeInSubqueries;
    }

    @Override
    public boolean hasNegativeSearchField(String fieldName) {
        boolean hasPositiveInSubqueries = this.queries.stream().anyMatch(q -> q.hasPositiveSearchField(fieldName));
        boolean hasNegativeInSubqueries = this.queries.stream().anyMatch(q -> q.hasNegativeSearchField(fieldName));
        return this.nonEmpty && !"andnot".equals(this.op) && hasNegativeInSubqueries || "andnot".equals(this.op) && hasPositiveInSubqueries;
    }

    @Override
    public boolean hasNegativeSearchField(String fieldName, Object value) {
        boolean hasPositiveInSubqueries = this.queries.stream().anyMatch(q -> q.hasPositiveSearchField(fieldName, value));
        boolean hasNegativeInSubqueries = this.queries.stream().anyMatch(q -> q.hasNegativeSearchField(fieldName, value));
        return this.nonEmpty && !"andnot".equals(this.op) && hasNegativeInSubqueries || "andnot".equals(this.op) && hasPositiveInSubqueries;
    }
}

