/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.client.dsl;

import ai.vespa.client.dsl.Query;
import ai.vespa.client.dsl.QueryChain;
import ai.vespa.client.dsl.Select;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Rank
extends QueryChain {
    private List<Query> queries = new ArrayList<Query>();

    Rank(Query query, Query ... ranks) {
        this.query = query;
        this.nonEmpty = query.nonEmpty();
        this.queries.add(query);
        this.queries.addAll(Stream.of(ranks).collect(Collectors.toList()));
    }

    @Override
    public Select getSelect() {
        return this.sources.select;
    }

    public String toString() {
        return "rank(" + this.queries.stream().map(Objects::toString).collect(Collectors.joining(", ")) + ")";
    }

    @Override
    boolean hasPositiveSearchField(String fieldName) {
        return this.queries.get(0).hasPositiveSearchField(fieldName);
    }

    @Override
    boolean hasPositiveSearchField(String fieldName, Object value) {
        return this.queries.get(0).hasPositiveSearchField(fieldName, value);
    }

    @Override
    boolean hasNegativeSearchField(String fieldName) {
        return this.queries.get(0).hasNegativeSearchField(fieldName);
    }

    @Override
    boolean hasNegativeSearchField(String fieldName, Object value) {
        return this.queries.get(0).hasNegativeSearchField(fieldName, value);
    }
}

