/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.client.dsl;

import ai.vespa.client.dsl.A;
import ai.vespa.client.dsl.Annotation;
import ai.vespa.client.dsl.QueryChain;
import ai.vespa.client.dsl.Sources;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;

public class UserInput
extends QueryChain {
    Annotation annotation;
    String value;
    String indexField;
    String placeholder;
    boolean setDefaultIndex;

    UserInput(Sources sources, String value) {
        this(sources, A.empty(), value);
    }

    UserInput(Sources sources, Annotation annotation, String value) {
        this.sources = sources;
        this.annotation = annotation;
        this.value = value;
        this.nonEmpty = true;
        if (annotation.annotations.containsKey("defaultIndex")) {
            this.setDefaultIndex = true;
            this.indexField = (String)annotation.annotations.get("defaultIndex");
        } else {
            this.indexField = UUID.randomUUID().toString().substring(0, 5);
        }
    }

    UserInput(String value) {
        this(A.empty(), value);
    }

    UserInput(Annotation annotation, String value) {
        this(null, annotation, value);
    }

    @Override
    public void setIndex(int index) {
        this.placeholder = this.setDefaultIndex ? "_" + index + "_" + this.indexField : "_" + index;
    }

    public String toString() {
        return this.setDefaultIndex ? String.format("([%s]userInput(@%s))", this.annotation, this.placeholder) : String.format("userInput(@%s)", this.placeholder);
    }

    Map<String, String> getParam() {
        return Collections.singletonMap(this.placeholder, this.value);
    }

    @Override
    boolean hasPositiveSearchField(String fieldName) {
        return !"andnot".equals(this.op) && this.indexField.equals(fieldName);
    }

    @Override
    boolean hasPositiveSearchField(String fieldName, Object value) {
        return this.hasPositiveSearchField(fieldName) && this.value.equals(value);
    }

    @Override
    boolean hasNegativeSearchField(String fieldName) {
        return "andnot".equals(this.op) && this.indexField.equals(fieldName);
    }

    @Override
    boolean hasNegativeSearchField(String fieldName, Object value) {
        return this.hasNegativeSearchField(fieldName) && this.value.equals(value);
    }
}

