/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.plugin.util;

import com.yahoo.container.plugin.util.ArtifactId;
import com.yahoo.container.plugin.util.ThrowingFunction;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JarFiles {
    public static List<ArtifactId> providedArtifactsFromManifest(File jarFile) {
        return JarFiles.getManifest(jarFile).map(mf -> JarFiles.getMainAttributeValue(mf, "X-JDisc-Provided-Artifact").map(s -> Arrays.stream(s.split(",")).map(ArtifactId::fromStringValue).toList()).orElse(List.of())).orElse(List.of());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T withJarFile(File file, ThrowingFunction<JarFile, T> action) {
        try (JarFile jar = new JarFile(file);){
            JarFile t = action.apply(jar);
            return (T)t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T withInputStream(ZipFile zipFile, ZipEntry zipEntry, ThrowingFunction<InputStream, T> action) {
        try (InputStream is = zipFile.getInputStream(zipEntry);){
            InputStream t = action.apply(is);
            return (T)t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Optional<String> getMainAttributeValue(Manifest manifest, String attributeName) {
        return Optional.ofNullable(manifest.getMainAttributes().getValue(attributeName));
    }

    public static Optional<Manifest> getManifest(File jarFile) {
        return JarFiles.withJarFile(jarFile, jar -> Optional.ofNullable(jar.getManifest()));
    }
}

