/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.plugin.classanalysis;

import com.yahoo.container.plugin.classanalysis.AnalyzeClassVisitor;
import com.yahoo.container.plugin.classanalysis.ClassFileMetaData;
import com.yahoo.container.plugin.classanalysis.ImportCollector;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;

public class Analyze {
    static ClassFileMetaData analyzeClass(File classFile) {
        return Analyze.analyzeClass(classFile, null);
    }

    public static ClassFileMetaData analyzeClass(File classFile, ArtifactVersion artifactVersion) {
        try {
            return Analyze.analyzeClass(new FileInputStream(classFile), artifactVersion);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred when analyzing " + classFile.getPath(), e);
        }
    }

    public static ClassFileMetaData analyzeClass(InputStream inputStream, ArtifactVersion artifactVersion) {
        try {
            AnalyzeClassVisitor visitor = new AnalyzeClassVisitor(artifactVersion);
            new ClassReader(inputStream).accept((ClassVisitor)visitor, 2);
            return visitor.result();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static Optional<String> internalNameToClassName(String internalClassName) {
        if (internalClassName == null) {
            return Optional.empty();
        }
        return Analyze.getClassName(Type.getObjectType((String)internalClassName));
    }

    static Optional<String> getClassName(Type aType) {
        return switch (aType.getSort()) {
            case 9 -> Analyze.getClassName(aType.getElementType());
            case 10 -> Optional.of(aType.getClassName());
            case 11 -> Analyze.getClassName(aType.getReturnType());
            default -> Optional.empty();
        };
    }

    static AnnotationVisitor visitAnnotationDefault(final ImportCollector collector) {
        return new AnnotationVisitor(589824){

            public void visit(String name, Object value) {
            }

            public void visitEnum(String name, String desc, String value) {
                collector.addImportWithTypeDesc(desc);
            }

            public AnnotationVisitor visitArray(String name) {
                return this;
            }

            public AnnotationVisitor visitAnnotation(String name, String desc) {
                collector.addImportWithTypeDesc(desc);
                return this;
            }

            public void visitEnd() {
            }
        };
    }
}

