/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.plugin.util;

import com.yahoo.container.plugin.util.Artifacts;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;

public class TestBundleDependencyScopeTranslator
implements Artifacts.ScopeTranslator {
    private static final Logger log = Logger.getLogger(TestBundleDependencyScopeTranslator.class.getName());
    private final Map<Artifact, String> dependencyScopes;

    private TestBundleDependencyScopeTranslator(Map<Artifact, String> dependencyScopes) {
        this.dependencyScopes = dependencyScopes;
    }

    @Override
    public String scopeOf(Artifact artifact) {
        return Objects.requireNonNull(this.dependencyScopes.get(artifact), () -> "Could not lookup scope for " + artifact);
    }

    public static TestBundleDependencyScopeTranslator from(Collection<Artifact> dependencies, String rawConfig) {
        List<DependencyOverride> dependencyOverrides = TestBundleDependencyScopeTranslator.toDependencyOverrides(rawConfig);
        HashMap<Artifact, String> dependencyScopes = new HashMap<Artifact, String>();
        Map<String, Artifact> dependenciesById = dependencies.stream().collect(Collectors.toMap(Artifact::getId, Function.identity()));
        for (Artifact dependency : dependencies) {
            dependencyScopes.put(dependency, TestBundleDependencyScopeTranslator.getScopeForDependency(dependency, dependencyOverrides, dependenciesById));
        }
        return new TestBundleDependencyScopeTranslator(dependencyScopes);
    }

    private static List<DependencyOverride> toDependencyOverrides(String rawConfig) {
        if (rawConfig == null || rawConfig.isBlank()) {
            return List.of();
        }
        return Arrays.stream(rawConfig.split(",")).map(String::strip).filter(s -> !s.isBlank()).map(TestBundleDependencyScopeTranslator::toDependencyOverride).toList();
    }

    private static DependencyOverride toDependencyOverride(String overrideString) {
        String[] elements = overrideString.split(":");
        if (elements.length != 3) {
            throw new IllegalArgumentException("Invalid dependency override: " + overrideString);
        }
        return new DependencyOverride(elements[0], elements[1], elements[2]);
    }

    private static String getScopeForDependency(Artifact dependency, List<DependencyOverride> overrides, Map<String, Artifact> otherArtifacts) {
        String oldScope = dependency.getScope();
        if (!oldScope.equals("test")) {
            return oldScope;
        }
        for (DependencyOverride override : overrides) {
            for (Artifact dependent : TestBundleDependencyScopeTranslator.dependencyTrailOf(dependency, otherArtifacts)) {
                if (!override.isForArtifact(dependent)) continue;
                log.fine(() -> String.format("Overriding scope of '%s'; scope '%s' overridden to '%s'", dependency.getId(), oldScope, override.scope));
                return override.scope;
            }
        }
        log.fine(() -> String.format("Using default scope translation for '%s'; scope 'test' translated to 'compile'", dependency.getId()));
        return "compile";
    }

    private static List<Artifact> dependencyTrailOf(Artifact artifact, Map<String, Artifact> otherArtifacts) {
        return artifact.getDependencyTrail().stream().skip(1L).map(otherArtifacts::get).filter(Objects::nonNull).toList();
    }

    private static class DependencyOverride {
        final String groupId;
        final String artifactId;
        final String scope;

        DependencyOverride(String groupId, String artifactId, String scope) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.scope = scope;
        }

        boolean isForArtifact(Artifact artifact) {
            return artifact.getGroupId().equals(this.groupId) && artifact.getArtifactId().equals(this.artifactId);
        }
    }
}

