/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.plugin.classanalysis;

import com.yahoo.container.plugin.classanalysis.Analyze;
import com.yahoo.container.plugin.classanalysis.AnalyzeFieldVisitor;
import com.yahoo.container.plugin.classanalysis.AnalyzeMethodVisitor;
import com.yahoo.container.plugin.classanalysis.AnalyzeSignatureVisitor;
import com.yahoo.container.plugin.classanalysis.ClassFileMetaData;
import com.yahoo.container.plugin.classanalysis.ExportPackageAnnotation;
import com.yahoo.container.plugin.classanalysis.ImportCollector;
import com.yahoo.osgi.annotation.ExportPackage;
import com.yahoo.osgi.annotation.Version;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

class AnalyzeClassVisitor
extends ClassVisitor
implements ImportCollector {
    private String name = null;
    private final Set<String> imports = new HashSet<String>();
    private Optional<ExportPackageAnnotation> exportPackageAnnotation = Optional.empty();
    private final Optional<ArtifactVersion> defaultExportPackageVersion;

    AnalyzeClassVisitor(ArtifactVersion defaultExportPackageVersion) {
        super(458752);
        this.defaultExportPackageVersion = Optional.ofNullable(defaultExportPackageVersion);
    }

    @Override
    public Set<String> imports() {
        return this.imports;
    }

    public void visitAttribute(Attribute attribute) {
        this.addImport(Type.getObjectType((String)attribute.type));
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        Analyze.getClassName(Type.getReturnType((String)desc)).ifPresent(this.imports::add);
        Arrays.asList(Type.getArgumentTypes((String)desc)).forEach(argType -> Analyze.getClassName(argType).ifPresent(this.imports::add));
        if (exceptions != null) {
            Arrays.asList(exceptions).forEach(ex -> Analyze.internalNameToClassName(ex).ifPresent(this.imports::add));
        }
        AnalyzeSignatureVisitor.analyzeMethod(signature, this);
        return new AnalyzeMethodVisitor(this);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        Analyze.getClassName(Type.getType((String)desc)).ifPresent(this.imports::add);
        AnalyzeSignatureVisitor.analyzeField(signature, this);
        return new AnalyzeFieldVisitor(this);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.name = Analyze.internalNameToClassName(name).orElseThrow(() -> new RuntimeException("Unable to resolve class name for " + name));
        this.addImportWithInternalName(superName);
        Arrays.asList(interfaces).forEach(this::addImportWithInternalName);
        AnalyzeSignatureVisitor.analyzeClass(signature, this);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    public void visitOuterClass(String owner, String name, String desc) {
    }

    public void visitSource(String source, String debug) {
    }

    public void visitEnd() {
    }

    private static <T> T defaultVersionValue(String name) {
        try {
            return (T)Version.class.getMethod(name, new Class[0]).getDefaultValue();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Could not locate method " + name);
        }
    }

    private AnnotationVisitor visitExportPackage() {
        return new AnnotationVisitor(458752){
            private int major;
            private int minor;
            private int micro;
            private String qualifier;
            {
                this.major = AnalyzeClassVisitor.this.defaultExportPackageVersion.map(ArtifactVersion::getMajorVersion).orElse((Integer)AnalyzeClassVisitor.defaultVersionValue("major"));
                this.minor = AnalyzeClassVisitor.this.defaultExportPackageVersion.map(ArtifactVersion::getMinorVersion).orElse((Integer)AnalyzeClassVisitor.defaultVersionValue("minor"));
                this.micro = AnalyzeClassVisitor.this.defaultExportPackageVersion.map(ArtifactVersion::getIncrementalVersion).orElse((Integer)AnalyzeClassVisitor.defaultVersionValue("micro"));
                this.qualifier = (String)AnalyzeClassVisitor.defaultVersionValue("qualifier");
            }

            public void visit(String name, Object value) {
                if (name != null) {
                    switch (name) {
                        case "major": {
                            this.major = (Integer)value;
                            break;
                        }
                        case "minor": {
                            this.minor = (Integer)value;
                            break;
                        }
                        case "micro": {
                            this.micro = (Integer)value;
                            break;
                        }
                        case "qualifier": {
                            this.qualifier = (String)value;
                        }
                    }
                }
            }

            public void visitEnd() {
                AnalyzeClassVisitor.this.exportPackageAnnotation = Optional.of(new ExportPackageAnnotation(this.major, this.minor, this.micro, this.qualifier));
            }

            public void visitEnum(String name, String desc, String value) {
            }

            public AnnotationVisitor visitArray(String name) {
                return this;
            }

            public AnnotationVisitor visitAnnotation(String name, String desc) {
                return this;
            }
        };
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (ExportPackage.class.getName().equals(Type.getType((String)desc).getClassName())) {
            return this.visitExportPackage();
        }
        this.addImportWithTypeDesc(desc);
        return Analyze.visitAnnotationDefault(this);
    }

    ClassFileMetaData result() {
        assert (!this.imports.contains("int"));
        return new ClassFileMetaData(this.name, this.imports, this.exportPackageAnnotation);
    }
}

