/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.plugin.classanalysis;

import com.yahoo.container.plugin.classanalysis.Analyze;
import com.yahoo.container.plugin.classanalysis.AnalyzeClassVisitor;
import com.yahoo.container.plugin.classanalysis.ImportCollector;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

class AnalyzeMethodVisitor
extends MethodVisitor
implements ImportCollector {
    private final Set<String> imports = new HashSet<String>();
    private final AnalyzeClassVisitor analyzeClassVisitor;

    AnalyzeMethodVisitor(AnalyzeClassVisitor analyzeClassVisitor) {
        super(458752);
        this.analyzeClassVisitor = analyzeClassVisitor;
    }

    @Override
    public Set<String> imports() {
        return this.imports;
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        return this.visitAnnotation(desc, visible);
    }

    public AnnotationVisitor visitAnnotationDefault() {
        return Analyze.visitAnnotationDefault(this);
    }

    public void visitAttribute(Attribute attribute) {
        this.addImport(Type.getObjectType((String)attribute.type));
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.addImportWithTypeDesc(desc);
        return Analyze.visitAnnotationDefault(this);
    }

    public void visitEnd() {
        super.visitEnd();
        this.analyzeClassVisitor.addImports(this.imports);
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.addImportWithTypeDesc(desc);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        this.addImportWithInternalName(owner);
        Arrays.asList(Type.getArgumentTypes((String)desc)).forEach(this::addImport);
        this.addImport(Type.getReturnType((String)desc));
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.addImportWithInternalName(owner);
        this.addImportWithTypeDesc(desc);
    }

    public void visitTypeInsn(int opcode, String type) {
        this.addImportWithInternalName(type);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        if (type != null) {
            this.addImportWithInternalName(type);
        }
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        this.addImportWithTypeDesc(desc);
    }

    public void visitLdcInsn(Object constant) {
        if (constant instanceof Type) {
            this.addImport((Type)constant);
        }
    }

    public void visitInvokeDynamicInsn(String name, String desc, Handle bootstrapMethod, Object ... bootstrapMethodArgs) {
        this.addImportWithTypeDesc(desc);
        for (Object arg : bootstrapMethodArgs) {
            if (arg instanceof Type) {
                this.addImport((Type)arg);
                continue;
            }
            if (arg instanceof Handle) {
                this.addImportWithInternalName(((Handle)arg).getOwner());
                Arrays.asList(Type.getArgumentTypes((String)desc)).forEach(this::addImport);
                continue;
            }
            if (!(arg instanceof Number) && !(arg instanceof String)) {
                throw new AssertionError((Object)("Unexpected type " + arg.getClass() + " with value '" + arg + "'"));
            }
        }
    }

    public void visitMaxs(int maxStack, int maxLocals) {
    }

    public void visitLineNumber(int line, Label start) {
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        super.visitTableSwitchInsn(min, max, dflt, labels);
    }

    public void visitIincInsn(int variable, int increment) {
    }

    public void visitLabel(Label label) {
    }

    public void visitJumpInsn(int opcode, Label label) {
    }

    public void visitVarInsn(int opcode, int variable) {
    }

    public void visitIntInsn(int opcode, int operand) {
    }

    public void visitInsn(int opcode) {
    }

    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
    }

    public void visitCode() {
    }
}

