/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.plugin.bundle;

import com.yahoo.container.plugin.osgi.ExportPackageParser;
import com.yahoo.container.plugin.osgi.ExportPackages;
import com.yahoo.container.plugin.util.JarFiles;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.jar.Manifest;

public class AnalyzeBundle {
    public static List<ExportPackages.Export> exportedPackagesAggregated(Collection<File> jarFiles) {
        ArrayList<ExportPackages.Export> exports = new ArrayList<ExportPackages.Export>();
        for (File jarFile : jarFiles) {
            List<ExportPackages.Export> exported = AnalyzeBundle.exportedPackages(jarFile);
            exports.addAll(exported);
        }
        return exports;
    }

    static List<ExportPackages.Export> exportedPackages(File jarFile) {
        try {
            Manifest manifest;
            Optional<Manifest> jarManifest = JarFiles.getManifest(jarFile);
            if (jarManifest.isPresent() && AnalyzeBundle.isOsgiManifest(manifest = jarManifest.get())) {
                return AnalyzeBundle.parseExports(manifest);
            }
            return Collections.emptyList();
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Invalid manifest in bundle '%s'", jarFile.getPath()), e);
        }
    }

    public static Optional<String> bundleSymbolicName(File jarFile) {
        return JarFiles.getManifest(jarFile).flatMap(AnalyzeBundle::getBundleSymbolicName);
    }

    private static List<ExportPackages.Export> parseExports(Manifest jarManifest) {
        return AnalyzeBundle.getMainAttributeValue(jarManifest, "Export-Package").map(ExportPackageParser::parseExports).orElseGet(ArrayList::new);
    }

    private static Optional<String> getMainAttributeValue(Manifest manifest, String attributeName) {
        return Optional.ofNullable(manifest.getMainAttributes().getValue(attributeName));
    }

    private static boolean isOsgiManifest(Manifest mf) {
        return AnalyzeBundle.getBundleSymbolicName(mf).isPresent();
    }

    private static Optional<String> getBundleSymbolicName(Manifest mf) {
        return AnalyzeBundle.getMainAttributeValue(mf, "Bundle-SymbolicName");
    }
}

