/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.plugin.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;

public class Artifacts {
    public static ArtifactSet getArtifacts(MavenProject project) {
        return Artifacts.getArtifacts(project, new NoopScopeTranslator());
    }

    public static ArtifactSet getArtifacts(MavenProject project, ScopeTranslator scopeTranslator) {
        ArrayList<Artifact> jarArtifactsToInclude = new ArrayList<Artifact>();
        ArrayList<Artifact> jarArtifactsProvided = new ArrayList<Artifact>();
        ArrayList<Artifact> nonJarArtifactsToInclude = new ArrayList<Artifact>();
        ArrayList<Artifact> nonJarArtifactsProvided = new ArrayList<Artifact>();
        for (Artifact artifact : project.getArtifacts()) {
            String scope = scopeTranslator.scopeOf(artifact);
            if ("jar".equals(artifact.getType())) {
                if ("compile".equals(scope)) {
                    jarArtifactsToInclude.add(artifact);
                    continue;
                }
                if (!"provided".equals(scope)) continue;
                jarArtifactsProvided.add(artifact);
                continue;
            }
            if ("compile".equals(scope)) {
                nonJarArtifactsToInclude.add(artifact);
                continue;
            }
            if (!"provided".equals(scope)) continue;
            nonJarArtifactsProvided.add(artifact);
        }
        nonJarArtifactsToInclude.addAll(nonJarArtifactsProvided);
        return new ArtifactSet(jarArtifactsToInclude, jarArtifactsProvided, nonJarArtifactsToInclude);
    }

    public static Collection<Artifact> getArtifactsToInclude(MavenProject project) {
        return Artifacts.getArtifacts(project, new NoopScopeTranslator()).getJarArtifactsToInclude();
    }

    public static class ArtifactSet {
        private final List<Artifact> jarArtifactsToInclude;
        private final List<Artifact> jarArtifactsProvided;
        private final List<Artifact> nonJarArtifacts;

        private ArtifactSet(List<Artifact> jarArtifactsToInclude, List<Artifact> jarArtifactsProvided, List<Artifact> nonJarArtifacts) {
            this.jarArtifactsToInclude = jarArtifactsToInclude;
            this.jarArtifactsProvided = jarArtifactsProvided;
            this.nonJarArtifacts = nonJarArtifacts;
        }

        public List<Artifact> getJarArtifactsToInclude() {
            return this.jarArtifactsToInclude;
        }

        public List<Artifact> getJarArtifactsProvided() {
            return this.jarArtifactsProvided;
        }

        public List<Artifact> getNonJarArtifacts() {
            return this.nonJarArtifacts;
        }
    }

    private static class NoopScopeTranslator
    implements ScopeTranslator {
        private NoopScopeTranslator() {
        }

        @Override
        public String scopeOf(Artifact artifact) {
            return artifact.getScope();
        }
    }

    static interface ScopeTranslator {
        public String scopeOf(Artifact var1);
    }
}

