/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.plugin.mojo;

import com.yahoo.container.plugin.util.JarFiles;
import java.io.File;
import java.nio.channels.Channels;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.jar.JarArchiver;

abstract class AbstractAssembleBundleMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}")
    MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    MavenSession session;
    @Parameter
    MavenArchiveConfiguration archiveConfiguration = new MavenArchiveConfiguration();

    AbstractAssembleBundleMojo() {
    }

    void addDirectory(JarArchiver jarArchiver, Path directory) {
        if (Files.isDirectory(directory, new LinkOption[0])) {
            jarArchiver.addDirectory(directory.toFile());
        }
    }

    void createArchive(JarArchiver jarArchiver, Path jarFile, Path manifestFile) throws MojoExecutionException {
        this.archiveConfiguration.setForced(true);
        this.archiveConfiguration.setManifestFile(manifestFile.toFile());
        MavenArchiver mavenArchiver = new MavenArchiver();
        mavenArchiver.setArchiver(jarArchiver);
        mavenArchiver.setOutputFile(jarFile.toFile());
        try {
            mavenArchiver.createArchive(this.session, this.project, this.archiveConfiguration);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error creating archive " + jarFile.toFile().getName(), e);
        }
    }

    void addArtifacts(JarArchiver jarArchiver, Collection<Artifact> artifacts) {
        for (Artifact artifact : artifacts) {
            if ("jar".equals(artifact.getType())) {
                jarArchiver.addFile(artifact.getFile(), "dependencies/" + artifact.getFile().getName());
                this.copyConfigDefinitions(artifact.getFile(), jarArchiver);
                continue;
            }
            this.getLog().warn((CharSequence)("Unknown artifact type " + artifact.getType()));
        }
    }

    private void copyConfigDefinitions(File file, JarArchiver jarArchiver) {
        JarFiles.withJarFile(file, jarFile -> {
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith("configdefinitions/") || !name.endsWith(".def")) continue;
                this.copyConfigDefinition((JarFile)jarFile, entry, jarArchiver);
            }
            return null;
        });
    }

    private void copyConfigDefinition(JarFile jarFile, ZipEntry entry, JarArchiver jarArchiver) {
        JarFiles.withInputStream(jarFile, entry, input -> {
            String defPath = entry.getName().replace("/", File.separator);
            File destinationFile = new File(this.project.getBuild().getOutputDirectory(), defPath);
            destinationFile.getParentFile().mkdirs();
            com.yahoo.container.plugin.util.Files.withFileOutputStream(destinationFile, output -> {
                output.getChannel().transferFrom(Channels.newChannel(input), 0L, Long.MAX_VALUE);
                return null;
            });
            jarArchiver.addFile(destinationFile, entry.getName());
            return null;
        });
    }
}

