/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.plugin.mojo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;

class TestProvidedArtifacts {
    private final List<Artifact> artifacts;

    private TestProvidedArtifacts(List<Artifact> artifacts) {
        this.artifacts = artifacts;
    }

    boolean isTestProvided(Artifact artifact) {
        return this.artifacts.contains(artifact);
    }

    static TestProvidedArtifacts from(Map<String, Artifact> artifacts, String configString) {
        if (configString == null || configString.isBlank()) {
            return new TestProvidedArtifacts(List.of());
        }
        return new TestProvidedArtifacts(TestProvidedArtifacts.getTestProvidedArtifacts(artifacts, configString));
    }

    private static List<Artifact> getTestProvidedArtifacts(Map<String, Artifact> artifacts, String configString) {
        List<String> testProvidedArtifactStringIds = TestProvidedArtifacts.toTestProvidedArtifactStringIds(configString);
        ArrayList<Artifact> testProvidedArtifacts = new ArrayList<Artifact>();
        for (Artifact artifact : artifacts.values()) {
            boolean hasTestProvidedArtifactAsParent = TestProvidedArtifacts.dependencyTrail(artifact, artifacts).anyMatch(parent -> testProvidedArtifactStringIds.contains(TestProvidedArtifacts.toArtifactStringId(parent)));
            boolean isBlacklisted = testProvidedArtifactStringIds.contains(TestProvidedArtifacts.toBlacklistedArtifactStringId(artifact));
            if (!hasTestProvidedArtifactAsParent || isBlacklisted) continue;
            testProvidedArtifacts.add(artifact);
        }
        return testProvidedArtifacts;
    }

    private static List<String> toTestProvidedArtifactStringIds(String commaSeparatedString) {
        if (commaSeparatedString == null || commaSeparatedString.isBlank()) {
            return List.of();
        }
        return Arrays.stream(commaSeparatedString.split(",")).map(String::strip).filter(s -> !s.isBlank()).collect(Collectors.toList());
    }

    private static Stream<Artifact> dependencyTrail(Artifact artifact, Map<String, Artifact> otherArtifacts) {
        return artifact.getDependencyTrail().stream().map(parentId -> (Artifact)otherArtifacts.get(TestProvidedArtifacts.stripVersionAndScope(parentId))).filter(Objects::nonNull);
    }

    private static String stripVersionAndScope(String fullArtifactIdentifier) {
        int firstDelimiter = fullArtifactIdentifier.indexOf(58);
        int secondDelimiter = fullArtifactIdentifier.indexOf(58, firstDelimiter + 1);
        return fullArtifactIdentifier.substring(0, secondDelimiter);
    }

    private static String toArtifactStringId(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId();
    }

    private static String toBlacklistedArtifactStringId(Artifact artifact) {
        return "!" + TestProvidedArtifacts.toArtifactStringId(artifact);
    }
}

