/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.plugin.bundle;

import com.yahoo.container.plugin.osgi.ExportPackageParser;
import com.yahoo.container.plugin.osgi.ExportPackages;
import com.yahoo.container.plugin.util.JarFiles;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.stream.Collectors;

public class AnalyzeBundle {
    public static PublicPackages publicPackagesAggregated(Collection<File> jarFiles) {
        ArrayList<ExportPackages.Export> exports = new ArrayList<ExportPackages.Export>();
        ArrayList<String> globals = new ArrayList<String>();
        for (File jarFile : jarFiles) {
            PublicPackages pp = AnalyzeBundle.publicPackages(jarFile);
            exports.addAll(pp.exports);
            globals.addAll(pp.globals);
            if (pp.globals.isEmpty()) continue;
            throw new RuntimeException("Found global packages in bundle " + jarFile.getAbsolutePath());
        }
        return new PublicPackages(exports, globals);
    }

    static PublicPackages publicPackages(File jarFile) {
        try {
            Manifest manifest;
            Optional<Manifest> jarManifest = JarFiles.getManifest(jarFile);
            if (jarManifest.isPresent() && AnalyzeBundle.isOsgiManifest(manifest = jarManifest.get())) {
                return new PublicPackages(AnalyzeBundle.parseExports(manifest), AnalyzeBundle.parseGlobals(manifest));
            }
            return new PublicPackages(Collections.emptyList(), Collections.emptyList());
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Invalid manifest in bundle '%s'", jarFile.getPath()), e);
        }
    }

    public static Optional<String> bundleSymbolicName(File jarFile) {
        return JarFiles.getManifest(jarFile).flatMap(AnalyzeBundle::getBundleSymbolicName);
    }

    private static List<ExportPackages.Export> parseExportsFromAttribute(Manifest manifest, String attributeName) {
        return AnalyzeBundle.getMainAttributeValue(manifest, attributeName).map(ExportPackageParser::parseExports).orElseGet(() -> new ArrayList());
    }

    private static List<ExportPackages.Export> parseExports(Manifest jarManifest) {
        return AnalyzeBundle.parseExportsFromAttribute(jarManifest, "Export-Package");
    }

    private static List<String> parseGlobals(Manifest manifest) {
        List<ExportPackages.Export> globals = AnalyzeBundle.parseExportsFromAttribute(manifest, "Global-Package");
        for (ExportPackages.Export export : globals) {
            if (export.getParameters().isEmpty()) continue;
            throw new RuntimeException("Parameters not valid for Global-Package.");
        }
        return globals.stream().flatMap(g -> g.getPackageNames().stream()).collect(Collectors.toList());
    }

    private static Optional<String> getMainAttributeValue(Manifest manifest, String attributeName) {
        return Optional.ofNullable(manifest.getMainAttributes().getValue(attributeName));
    }

    private static boolean isOsgiManifest(Manifest mf) {
        return AnalyzeBundle.getBundleSymbolicName(mf).isPresent();
    }

    private static Optional<String> getBundleSymbolicName(Manifest mf) {
        return AnalyzeBundle.getMainAttributeValue(mf, "Bundle-SymbolicName");
    }

    public static class PublicPackages {
        public final List<ExportPackages.Export> exports;
        public final List<String> globals;

        PublicPackages(List<ExportPackages.Export> exports, List<String> globals) {
            this.exports = exports;
            this.globals = globals;
        }

        public Set<String> exportedPackageNames() {
            return this.exports.stream().map(ExportPackages.Export::getPackageNames).flatMap(Collection::stream).collect(Collectors.toSet());
        }
    }
}

