/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.plugin.util;

import java.net.URL;

public class JdkPackages {
    public static boolean isJdkPackage(String pkg) {
        return JdkPackages.hasJdkExclusivePrefix(pkg) || JdkPackages.isResourceInPlatformClassLoader(pkg);
    }

    private static boolean isResourceInPlatformClassLoader(String klass) {
        String klassAsPath = klass.replaceAll("\\.", "/") + ".class";
        URL resource = JdkPackages.getPlatformClassLoader().getResource(klassAsPath);
        return resource != null;
    }

    private static ClassLoader getPlatformClassLoader() {
        ClassLoader platform = JdkPackages.class.getClassLoader().getParent();
        assert (platform.getName().equals("platform"));
        return platform;
    }

    private static boolean hasJdkExclusivePrefix(String pkg) {
        return pkg.startsWith("java.") || pkg.startsWith("sun.");
    }
}

