/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.plugin.classanalysis;

import java.util.Objects;
import java.util.regex.Pattern;

public class ExportPackageAnnotation {
    private final int major;
    private final int minor;
    private final int micro;
    private final String qualifier;
    private static final Pattern QUALIFIER_PATTERN = Pattern.compile("[\\p{Alpha}\\p{Digit}_-]*");

    public ExportPackageAnnotation(int major, int minor, int micro, String qualifier) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.qualifier = qualifier;
        ExportPackageAnnotation.requireNonNegative(major, "major");
        ExportPackageAnnotation.requireNonNegative(minor, "minor");
        ExportPackageAnnotation.requireNonNegative(micro, "micro");
        if (!QUALIFIER_PATTERN.matcher(qualifier).matches()) {
            throw new IllegalArgumentException(ExportPackageAnnotation.exportPackageError(String.format("qualifier must follow the format (alpha|digit|'_'|'-')* but was '%s'.", qualifier)));
        }
    }

    public String osgiVersion() {
        return String.format("%d.%d.%d", this.major, this.minor, this.micro) + (this.qualifier.isEmpty() ? "" : "." + this.qualifier);
    }

    private static String exportPackageError(String msg) {
        return "ExportPackage anntotation: " + msg;
    }

    private static void requireNonNegative(int i, String fieldName) {
        if (i < 0) {
            throw new IllegalArgumentException(ExportPackageAnnotation.exportPackageError(String.format("%s must be non-negative but was %d.", fieldName, i)));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExportPackageAnnotation that = (ExportPackageAnnotation)o;
        return this.major == that.major && this.minor == that.minor && this.micro == that.micro && Objects.equals(this.qualifier, that.qualifier);
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.micro, this.qualifier);
    }
}

