/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.plugin.mojo;

import com.google.common.base.Preconditions;
import com.yahoo.container.plugin.bundle.AnalyzeBundle;
import com.yahoo.container.plugin.mojo.Artifacts;
import com.yahoo.container.plugin.osgi.ProjectBundleClassPaths;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate-bundle-classpath-mappings", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class GenerateBundleClassPathMappingsMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}")
    private MavenProject project = null;
    @Parameter(alias="Bundle-SymbolicName", defaultValue="${project.artifactId}")
    private String bundleSymbolicName = null;

    public void execute() throws MojoExecutionException {
        Preconditions.checkNotNull((Object)this.bundleSymbolicName);
        Artifacts.ArtifactSet artifacts = Artifacts.getArtifacts(this.project);
        List<Artifact> embeddedArtifacts = artifacts.getJarArtifactsToInclude();
        List<Artifact> providedJarArtifacts = artifacts.getJarArtifactsProvided();
        List embeddedArtifactsFiles = embeddedArtifacts.stream().map(Artifact::getFile).collect(Collectors.toList());
        List<String> classPathElements = Stream.concat(Stream.of(this.outputDirectory()), embeddedArtifactsFiles.stream()).map(File::getAbsolutePath).collect(Collectors.toList());
        ProjectBundleClassPaths classPathMappings = new ProjectBundleClassPaths(new ProjectBundleClassPaths.BundleClasspathMapping(this.bundleSymbolicName, classPathElements), providedJarArtifacts.stream().map(f -> this.createDependencyClasspathMapping((Artifact)f)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
        try {
            ProjectBundleClassPaths.save(this.testOutputPath().resolve("bundle-plugin.bundle-classpath-mappings.json"), classPathMappings);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error saving to file " + this.testOutputPath(), (Exception)e);
        }
    }

    private File outputDirectory() {
        return new File(this.project.getBuild().getOutputDirectory());
    }

    private Path testOutputPath() {
        return Paths.get(this.project.getBuild().getTestOutputDirectory(), new String[0]);
    }

    Optional<ProjectBundleClassPaths.BundleClasspathMapping> createDependencyClasspathMapping(Artifact artifact) {
        return GenerateBundleClassPathMappingsMojo.bundleSymbolicNameForArtifact(artifact).map(name -> new ProjectBundleClassPaths.BundleClasspathMapping((String)name, Arrays.asList(artifact.getFile().getAbsolutePath())));
    }

    private static Optional<String> bundleSymbolicNameForArtifact(Artifact artifact) {
        if (artifact.getFile().getName().endsWith(".jar")) {
            return AnalyzeBundle.bundleSymbolicName(artifact.getFile());
        }
        return Optional.of(artifact.getArtifactId());
    }
}

