/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.plugin.util;

import com.yahoo.container.plugin.util.ThrowingFunction;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class IO {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T withFileInputStream(File file, ThrowingFunction<FileInputStream, T> f) {
        try (FileInputStream fis = new FileInputStream(file);){
            FileInputStream fileInputStream = f.apply(fis);
            return (T)fileInputStream;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T withFileOutputStream(File file, ThrowingFunction<OutputStream, T> f) {
        IO.makeDirectoriesRecursive(file.getParentFile());
        try (FileOutputStream fos = new FileOutputStream(file);){
            OutputStream outputStream = f.apply(fos);
            return (T)outputStream;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void makeDirectoriesRecursive(File file) {
        if (!file.mkdirs() && !file.isDirectory()) {
            throw new RuntimeException("Could not create directory " + file.getPath());
        }
    }
}

