/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.application.container;

import com.yahoo.document.config.DocumentmanagerConfig;
import com.yahoo.documentapi.DocumentAccessParams;
import com.yahoo.documentapi.local.LocalDocumentAccess;
import com.yahoo.schema.derived.Deriver;
import java.io.File;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DocumentAccesses {
    private DocumentAccesses() {
    }

    public static LocalDocumentAccess createFromSchemas(String schemaDirectory) {
        File[] schemasFiles = new File(schemaDirectory).listFiles(name -> name.toString().endsWith(".sd"));
        if (schemasFiles == null) {
            throw new IllegalArgumentException(schemaDirectory + " is not a directory");
        }
        if (schemasFiles.length == 0) {
            throw new IllegalArgumentException("No schema files found under " + schemaDirectory);
        }
        DocumentmanagerConfig config = Deriver.getDocumentManagerConfig(Stream.of(schemasFiles).map(File::toString).collect(Collectors.toList())).build();
        return new LocalDocumentAccess(new DocumentAccessParams().setDocumentmanagerConfig(config));
    }
}

