/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.application.container;

import com.yahoo.api.annotations.Beta;
import com.yahoo.application.container.ApplicationException;
import com.yahoo.application.container.handler.Request;
import com.yahoo.application.container.handler.Response;
import com.yahoo.jdisc.handler.CompletionHandler;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.handler.RequestDispatch;
import com.yahoo.jdisc.handler.ResponseHandler;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.jdisc.service.CurrentContainer;
import com.yahoo.jdisc.test.TestDriver;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

@Beta
final class SynchronousRequestResponseHandler {
    SynchronousRequestResponseHandler() {
    }

    Response handleRequest(Request request, TestDriver driver) {
        BlockingResponseHandler responseHandler = new BlockingResponseHandler();
        ContentChannel inputRequestChannel = this.connectRequest(request, driver, responseHandler);
        this.writeRequestBody(request, inputRequestChannel);
        return responseHandler.getResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRequestBody(Request request, ContentChannel inputRequestChannel) {
        ArrayList<BlockingCompletionHandler> completionHandlers = new ArrayList<BlockingCompletionHandler>();
        if (request.getBody().length > 0) {
            BlockingCompletionHandler w = new BlockingCompletionHandler();
            try {
                inputRequestChannel.write(ByteBuffer.wrap(request.getBody()), (CompletionHandler)w);
                completionHandlers.add(w);
            }
            finally {
                BlockingCompletionHandler c = new BlockingCompletionHandler();
                inputRequestChannel.close((CompletionHandler)c);
                completionHandlers.add(c);
            }
        } else {
            BlockingCompletionHandler c = new BlockingCompletionHandler();
            inputRequestChannel.close((CompletionHandler)c);
            completionHandlers.add(c);
        }
        for (BlockingCompletionHandler completionHandler : completionHandlers) {
            completionHandler.waitUntilCompleted();
        }
    }

    private ContentChannel connectRequest(final Request request, final TestDriver driver, final ResponseHandler responseHandler) {
        RequestDispatch dispatch = new RequestDispatch(){

            protected com.yahoo.jdisc.Request newRequest() {
                return SynchronousRequestResponseHandler.createDiscRequest(request, (CurrentContainer)driver);
            }

            public ContentChannel handleResponse(com.yahoo.jdisc.Response response) {
                return responseHandler.handleResponse(response);
            }
        };
        return dispatch.connect();
    }

    private static String getScheme(String uri) {
        int colonPos = uri.indexOf(58);
        if (colonPos < 0) {
            return "";
        }
        return uri.substring(0, colonPos);
    }

    private static com.yahoo.jdisc.Request createDiscRequest(Request request, CurrentContainer currentContainer) {
        com.yahoo.jdisc.Request discRequest;
        String scheme = SynchronousRequestResponseHandler.getScheme(request.getUri());
        if ("http".equals(scheme) || "https".equals(scheme)) {
            HttpRequest httpRequest = HttpRequest.newServerRequest((CurrentContainer)currentContainer, (URI)URI.create(request.getUri()), (HttpRequest.Method)HttpRequest.Method.valueOf((String)request.getMethod().name()));
            request.getUserPrincipal().ifPresent(arg_0 -> ((HttpRequest)httpRequest).setUserPrincipal(arg_0));
            request.remoteAddress().ifPresent(arg_0 -> ((HttpRequest)httpRequest).setRemoteAddress(arg_0));
            discRequest = httpRequest;
        } else {
            discRequest = new com.yahoo.jdisc.Request(currentContainer, URI.create(request.getUri()));
        }
        for (Map.Entry<String, List<String>> entry : request.getHeaders().entrySet()) {
            discRequest.headers().add(entry.getKey(), entry.getValue());
        }
        discRequest.context().putAll(request.getAttributes());
        return discRequest;
    }

    private static byte[] concatenateBuffers(List<ByteBuffer> byteBuffers) {
        int totalSize = 0;
        for (ByteBuffer responseBuffer : byteBuffers) {
            totalSize += responseBuffer.remaining();
        }
        ByteBuffer totalBuffer = ByteBuffer.allocate(totalSize);
        for (ByteBuffer responseBuffer : byteBuffers) {
            totalBuffer.put(responseBuffer);
        }
        return totalBuffer.array();
    }

    private static void copyResponseHeaders(Response response, com.yahoo.jdisc.Response discResponse) {
        for (Map.Entry entry : discResponse.headers().entrySet()) {
            response.getHeaders().put((String)entry.getKey(), (List)entry.getValue());
        }
    }

    private static class BlockingResponseHandler
    implements ResponseHandler,
    ContentChannel {
        private volatile com.yahoo.jdisc.Response discResponse = null;
        private CountDownLatch closedLatch = new CountDownLatch(1);
        private final List<ByteBuffer> responseBuffers = new ArrayList<ByteBuffer>();

        private BlockingResponseHandler() {
        }

        public ContentChannel handleResponse(com.yahoo.jdisc.Response discResponse) {
            this.discResponse = discResponse;
            return this;
        }

        public Response getResponse() {
            try {
                this.closedLatch.await();
            }
            catch (InterruptedException e) {
                throw new ApplicationException(e);
            }
            byte[] totalBuffer = SynchronousRequestResponseHandler.concatenateBuffers(this.responseBuffers);
            Response response = new Response(this.discResponse.getStatus(), totalBuffer);
            SynchronousRequestResponseHandler.copyResponseHeaders(response, this.discResponse);
            return response;
        }

        public void write(ByteBuffer byteBuffer, CompletionHandler completionHandler) {
            this.responseBuffers.add(byteBuffer);
            completionHandler.completed();
        }

        public void close(CompletionHandler completionHandler) {
            completionHandler.completed();
            this.closedLatch.countDown();
        }
    }

    private static class BlockingCompletionHandler
    implements CompletionHandler {
        private volatile Throwable throwable;
        private CountDownLatch doneLatch = new CountDownLatch(1);

        private BlockingCompletionHandler() {
        }

        public void completed() {
            this.doneLatch.countDown();
        }

        public void failed(Throwable t) {
            this.throwable = t;
            this.doneLatch.countDown();
        }

        public void waitUntilCompleted() {
            try {
                this.doneLatch.await();
            }
            catch (InterruptedException e) {
                throw new ApplicationException(e);
            }
            if (this.throwable != null) {
                if (this.throwable instanceof RuntimeException) {
                    throw (RuntimeException)this.throwable;
                }
                throw new RuntimeException(this.throwable);
            }
        }
    }
}

