/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.application.container.handler;

import com.yahoo.api.annotations.Beta;
import com.yahoo.application.container.handler.Headers;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

@Beta
public class Request {
    private final Headers headers = new Headers();
    private final String uri;
    private final byte[] body;
    private final Method method;
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private final Principal userPrincipal;

    public Request(String uri) {
        this(uri, new byte[0]);
    }

    public Request(String uri, byte[] body) {
        this(uri, body, Method.GET);
    }

    public Request(String uri, String body) {
        this(uri, body.getBytes(StandardCharsets.UTF_8), Method.GET);
    }

    public Request(String uri, byte[] body, Method method) {
        this(uri, body, method, null);
    }

    public Request(String uri, byte[] body, Method method, Principal principal) {
        this.uri = uri;
        this.body = body;
        this.method = method;
        this.userPrincipal = principal;
    }

    public Request(String uri, String body, Method method) {
        this(uri, body.getBytes(StandardCharsets.UTF_8), method);
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public byte[] getBody() {
        return this.body;
    }

    public String getUri() {
        return this.uri;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public String toString() {
        String bodyStr = this.body == null || this.body.length == 0 ? "[empty]" : "[omitted]";
        return "Request to " + this.uri + ", headers: " + this.headers + ", body: " + bodyStr;
    }

    public Method getMethod() {
        return this.method;
    }

    public Optional<Principal> getUserPrincipal() {
        return Optional.ofNullable(this.userPrincipal);
    }

    public static enum Method {
        OPTIONS,
        GET,
        HEAD,
        POST,
        PUT,
        PATCH,
        DELETE,
        TRACE,
        CONNECT;

    }
}

