/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.application;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.LeafNode;
import com.yahoo.config.LeafNodeMaps;
import com.yahoo.config.LeafNodeVector;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public final class MockApplicationConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "344d60741788d0ae7e460c04670c3a17";
    public static final String CONFIG_DEF_NAME = "mock-application";
    public static final String CONFIG_DEF_NAMESPACE = "application";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=application", "mystruct.id string", "mystruct.value string", "mystructlist[].id string", "mystructlist[].value string", "mylist[] string", "mymap{} string", "mymapstruct{}.id string", "mymapstruct{}.value string"};
    private final Mystruct mystruct;
    private final InnerNodeVector<Mystructlist> mystructlist;
    private final LeafNodeVector<String, StringNode> mylist;
    private final Map<String, StringNode> mymap;
    private final Map<String, Mymapstruct> mymapstruct;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public MockApplicationConfig(Builder builder) {
        this(builder, true);
    }

    private MockApplicationConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for mock-application must be initialized: " + builder.__uninitialized);
        }
        this.mystruct = new Mystruct(builder.mystruct, throwIfUninitialized);
        this.mystructlist = Mystructlist.createVector(builder.mystructlist);
        this.mylist = new LeafNodeVector(builder.mylist, (LeafNode)new StringNode());
        this.mymap = LeafNodeMaps.asNodeMap(builder.mymap, (LeafNode)new StringNode());
        this.mymapstruct = Mymapstruct.createMap(builder.mymapstruct);
    }

    public Mystruct mystruct() {
        return this.mystruct;
    }

    public List<Mystructlist> mystructlist() {
        return this.mystructlist;
    }

    public Mystructlist mystructlist(int i) {
        return (Mystructlist)((Object)this.mystructlist.get(i));
    }

    public List<String> mylist() {
        return this.mylist.asList();
    }

    public String mylist(int i) {
        return ((StringNode)this.mylist.get(i)).value();
    }

    public Map<String, String> mymap() {
        return LeafNodeMaps.asValueMap(this.mymap);
    }

    public String mymap(String key) {
        return this.mymap.get(key).value();
    }

    public Map<String, Mymapstruct> mymapstruct() {
        return Collections.unmodifiableMap(this.mymapstruct);
    }

    public Mymapstruct mymapstruct(String key) {
        return this.mymapstruct.get(key);
    }

    private ChangesRequiringRestart getChangesRequiringRestart(MockApplicationConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public Mystruct.Builder mystruct = new Mystruct.Builder();
        public List<Mystructlist.Builder> mystructlist = new ArrayList<Mystructlist.Builder>();
        public List<String> mylist = new ArrayList<String>();
        public Map<String, String> mymap = new LinkedHashMap<String, String>();
        public Map<String, Mymapstruct.Builder> mymapstruct = new LinkedHashMap<String, Mymapstruct.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(MockApplicationConfig config) {
            this.mystruct(new Mystruct.Builder(config.mystruct()));
            for (Mystructlist mystructlist : config.mystructlist()) {
                this.mystructlist(new Mystructlist.Builder(mystructlist));
            }
            this.mylist(config.mylist());
            this.mymap(config.mymap());
            for (Map.Entry entry : config.mymapstruct().entrySet()) {
                this.mymapstruct((String)entry.getKey(), new Mymapstruct.Builder((Mymapstruct)((Object)entry.getValue())));
            }
        }

        private Builder override(Builder __superior) {
            this.mystruct(this.mystruct.override(__superior.mystruct));
            if (!__superior.mystructlist.isEmpty()) {
                this.mystructlist.addAll(__superior.mystructlist);
            }
            if (!__superior.mylist.isEmpty()) {
                this.mylist.addAll(__superior.mylist);
            }
            this.mymap(__superior.mymap);
            this.mymapstruct(__superior.mymapstruct);
            return this;
        }

        public Builder mystruct(Mystruct.Builder __builder) {
            this.mystruct = __builder;
            return this;
        }

        public Builder mystruct(Consumer<Mystruct.Builder> __func) {
            Mystruct.Builder __inner = new Mystruct.Builder();
            __func.accept(__inner);
            this.mystruct = __inner;
            return this;
        }

        public Builder mystructlist(Mystructlist.Builder __builder) {
            this.mystructlist.add(__builder);
            return this;
        }

        public Builder mystructlist(Consumer<Mystructlist.Builder> __func) {
            Mystructlist.Builder __inner = new Mystructlist.Builder();
            __func.accept(__inner);
            this.mystructlist.add(__inner);
            return this;
        }

        public Builder mystructlist(List<Mystructlist.Builder> __builders) {
            this.mystructlist = __builders;
            return this;
        }

        public Builder mylist(String __value) {
            this.mylist.add(__value);
            return this;
        }

        public Builder mylist(Collection<String> __values) {
            this.mylist.addAll(__values);
            return this;
        }

        public Builder mymap(String __key, String __value) {
            this.mymap.put(__key, __value);
            return this;
        }

        public Builder mymap(Map<String, String> __values) {
            this.mymap.putAll(__values);
            return this;
        }

        public Builder mymapstruct(String __key, Mymapstruct.Builder __value) {
            this.mymapstruct.put(__key, __value);
            return this;
        }

        public Builder mymapstruct(Map<String, Mymapstruct.Builder> __values) {
            this.mymapstruct.putAll(__values);
            return this;
        }

        public Builder mymapstruct(String __key, Consumer<Mymapstruct.Builder> __func) {
            Mymapstruct.Builder __inner = new Mymapstruct.Builder();
            __func.accept(__inner);
            this.mymapstruct.put(__key, __inner);
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return MockApplicationConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return MockApplicationConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return MockApplicationConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public MockApplicationConfig build() {
            return new MockApplicationConfig(this);
        }
    }

    public static final class Mystruct
    extends InnerNode {
        private final StringNode id;
        private final StringNode value;

        public Mystruct(Builder builder) {
            this(builder, true);
        }

        private Mystruct(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for mock-application.mystruct must be initialized: " + builder.__uninitialized);
            }
            this.id = builder.id == null ? new StringNode() : new StringNode(builder.id);
            this.value = builder.value == null ? new StringNode() : new StringNode(builder.value);
        }

        public String id() {
            return this.id.value();
        }

        public String value() {
            return this.value.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Mystruct newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("mystruct");
            return changes;
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("id", "value"));
            private String id = null;
            private String value = null;

            public Builder() {
            }

            public Builder(Mystruct config) {
                this.id(config.id());
                this.value(config.value());
            }

            private Builder override(Builder __superior) {
                if (__superior.id != null) {
                    this.id(__superior.id);
                }
                if (__superior.value != null) {
                    this.value(__superior.value);
                }
                return this;
            }

            public Builder id(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.id = __value;
                this.__uninitialized.remove("id");
                return this;
            }

            public Builder value(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.value = __value;
                this.__uninitialized.remove("value");
                return this;
            }

            public Mystruct build() {
                return new Mystruct(this);
            }
        }
    }

    public static final class Mystructlist
    extends InnerNode {
        private final StringNode id;
        private final StringNode value;

        public Mystructlist(Builder builder) {
            this(builder, true);
        }

        private Mystructlist(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for mock-application.mystructlist[] must be initialized: " + builder.__uninitialized);
            }
            this.id = builder.id == null ? new StringNode() : new StringNode(builder.id);
            this.value = builder.value == null ? new StringNode() : new StringNode(builder.value);
        }

        public String id() {
            return this.id.value();
        }

        public String value() {
            return this.value.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Mystructlist newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("mystructlist");
            return changes;
        }

        private static InnerNodeVector<Mystructlist> createVector(List<Builder> builders) {
            ArrayList<Mystructlist> elems = new ArrayList<Mystructlist>();
            for (Builder b : builders) {
                elems.add(new Mystructlist(b));
            }
            return new InnerNodeVector(elems);
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("id", "value"));
            private String id = null;
            private String value = null;

            public Builder() {
            }

            public Builder(Mystructlist config) {
                this.id(config.id());
                this.value(config.value());
            }

            private Builder override(Builder __superior) {
                if (__superior.id != null) {
                    this.id(__superior.id);
                }
                if (__superior.value != null) {
                    this.value(__superior.value);
                }
                return this;
            }

            public Builder id(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.id = __value;
                this.__uninitialized.remove("id");
                return this;
            }

            public Builder value(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.value = __value;
                this.__uninitialized.remove("value");
                return this;
            }

            public Mystructlist build() {
                return new Mystructlist(this);
            }
        }
    }

    public static final class Mymapstruct
    extends InnerNode {
        private final StringNode id;
        private final StringNode value;

        public Mymapstruct(Builder builder) {
            this(builder, true);
        }

        private Mymapstruct(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for mock-application.mymapstruct{} must be initialized: " + builder.__uninitialized);
            }
            this.id = builder.id == null ? new StringNode() : new StringNode(builder.id);
            this.value = builder.value == null ? new StringNode() : new StringNode(builder.value);
        }

        public String id() {
            return this.id.value();
        }

        public String value() {
            return this.value.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Mymapstruct newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("mymapstruct");
            return changes;
        }

        private static Map<String, Mymapstruct> createMap(Map<String, Builder> builders) {
            LinkedHashMap<String, Mymapstruct> ret = new LinkedHashMap<String, Mymapstruct>();
            for (String key : builders.keySet()) {
                ret.put(key, new Mymapstruct(builders.get(key)));
            }
            return Collections.unmodifiableMap(ret);
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("id", "value"));
            private String id = null;
            private String value = null;

            public Builder() {
            }

            public Builder(Mymapstruct config) {
                this.id(config.id());
                this.value(config.value());
            }

            private Builder override(Builder __superior) {
                if (__superior.id != null) {
                    this.id(__superior.id);
                }
                if (__superior.value != null) {
                    this.value(__superior.value);
                }
                return this;
            }

            public Builder id(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.id = __value;
                this.__uninitialized.remove("id");
                return this;
            }

            public Builder value(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.value = __value;
                this.__uninitialized.remove("value");
                return this;
            }

            public Mymapstruct build() {
                return new Mymapstruct(this);
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

