/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.application;

import com.google.common.annotations.Beta;
import com.yahoo.application.Application;
import com.yahoo.application.Networking;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.path.Path;
import com.yahoo.text.StringUtilities;
import com.yahoo.text.Utf8;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;

@Beta
public class ApplicationBuilder {
    private java.nio.file.Path applicationDir = Files.createTempDirectory("application", new FileAttribute[0]);
    private Networking networking = Networking.disable;

    public ApplicationBuilder servicesXml(String servicesXml) throws IOException {
        this.ensureNotAlreadyBuild();
        Object content = servicesXml.startsWith("<?xml") ? servicesXml : "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n" + servicesXml;
        this.createFile(this.applicationDir.resolve("services.xml"), (String)content);
        return this;
    }

    public ApplicationBuilder documentType(String name, String searchDefinition) throws IOException {
        java.nio.file.Path path = this.nestedResource(ApplicationPackage.SCHEMAS_DIR, name, ".sd");
        this.createFile(path, searchDefinition);
        return this;
    }

    public ApplicationBuilder rankExpression(String name, String rankExpressionContent) throws IOException {
        java.nio.file.Path path = this.nestedResource(ApplicationPackage.SCHEMAS_DIR, name, ".expression");
        this.createFile(path, rankExpressionContent);
        return this;
    }

    public ApplicationBuilder queryProfile(String name, String queryProfile) throws IOException {
        java.nio.file.Path path = this.nestedResource(ApplicationPackage.QUERY_PROFILES_DIR, name, ".xml");
        this.createFile(path, queryProfile);
        return this;
    }

    public ApplicationBuilder queryProfileType(String name, String queryProfileType) throws IOException {
        java.nio.file.Path path = this.nestedResource(ApplicationPackage.QUERY_PROFILE_TYPES_DIR, name, ".xml");
        this.createFile(path, queryProfileType);
        return this;
    }

    public ApplicationBuilder networking(Networking networking) {
        this.networking = networking;
        return this;
    }

    public Application build() {
        Application application = new Application(this.applicationDir, this.networking, true);
        this.applicationDir = null;
        return application;
    }

    private java.nio.file.Path nestedResource(Path nestedPath, String name, String fileType) {
        this.ensureNotAlreadyBuild();
        String nameWithoutSuffix = StringUtilities.stripSuffix((String)name, (String)fileType);
        return this.applicationDir.resolve(nestedPath.getRelative()).resolve(nameWithoutSuffix + fileType);
    }

    private void ensureNotAlreadyBuild() {
        if (this.applicationDir == null) {
            throw new RuntimeException("The ApplicationBuilder must not be used after the build method has been called.");
        }
    }

    private void createFile(java.nio.file.Path path, String content) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        Files.write(path, Utf8.toBytes((String)content), new OpenOption[0]);
    }

    java.nio.file.Path getPath() {
        return this.applicationDir;
    }
}

