/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.application.container;

import com.google.common.annotations.Beta;
import com.google.common.util.concurrent.ListenableFuture;
import com.yahoo.application.container.ApplicationException;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.chain.Chain;
import com.yahoo.processing.Processor;
import com.yahoo.processing.Request;
import com.yahoo.processing.Response;
import com.yahoo.processing.execution.chain.ChainRegistry;
import com.yahoo.processing.rendering.Renderer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.concurrent.ExecutionException;

@Beta
public abstract class ProcessingBase<REQUEST extends Request, RESPONSE extends Response, PROCESSOR extends Processor> {
    public abstract ChainRegistry<PROCESSOR> getChains();

    public final RESPONSE process(ComponentSpecification chain, REQUEST request) {
        Chain<PROCESSOR> processingChain = this.getChain(chain);
        return this.doProcess(processingChain, request);
    }

    protected abstract RESPONSE doProcess(Chain<PROCESSOR> var1, REQUEST var2);

    public final byte[] processAndRender(ComponentSpecification chainSpec, ComponentSpecification rendererSpec, REQUEST request) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Renderer<RESPONSE> renderer = this.getRenderer(rendererSpec);
        ListenableFuture<Boolean> renderTask = this.doProcessAndRender(chainSpec, request, renderer, stream);
        this.awaitFuture(renderTask);
        return stream.toByteArray();
    }

    private void awaitFuture(ListenableFuture<Boolean> renderTask) {
        try {
            renderTask.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new ApplicationException(e);
        }
    }

    protected abstract ListenableFuture<Boolean> doProcessAndRender(ComponentSpecification var1, REQUEST var2, Renderer<RESPONSE> var3, ByteArrayOutputStream var4) throws IOException;

    protected Chain<PROCESSOR> getChain(ComponentSpecification chainSpec) {
        Chain chain = (Chain)this.getChains().getComponent(chainSpec);
        if (chain == null) {
            throw new IllegalArgumentException("No such chain: " + chainSpec);
        }
        return chain;
    }

    protected final Renderer<RESPONSE> getRenderer(ComponentSpecification spec) {
        return this.doGetRenderer(spec);
    }

    protected abstract Renderer<RESPONSE> doGetRenderer(ComponentSpecification var1);
}

